/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.StackoneMcpDeleteRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpDeleteSecurity;
import com.stackone.stackone_client_java.operations.StackoneMcpDelete;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class StackoneMcpDeleteRequestBuilder {

    private StackoneMcpDeleteSecurity security;
    private String xAccountId;
    private String mcpSessionId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public StackoneMcpDeleteRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneMcpDeleteRequestBuilder security(StackoneMcpDeleteSecurity security) {
        Utils.checkNotNull(security, "security");
        this.security = security;
        return this;
    }

    public StackoneMcpDeleteRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public StackoneMcpDeleteRequestBuilder mcpSessionId(String mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = mcpSessionId;
        return this;
    }
                
    public StackoneMcpDeleteRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneMcpDeleteRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private StackoneMcpDeleteRequest buildRequest() {

        StackoneMcpDeleteRequest request = new StackoneMcpDeleteRequest(xAccountId,
            mcpSessionId);

        return request;
    }

    public CompletableFuture<StackoneMcpDeleteResponse> call() {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<StackoneMcpDeleteRequest, StackoneMcpDeleteResponse> operation
              = new StackoneMcpDelete.Async(
                                    sdkConfiguration, security, options,
                                    sdkConfiguration.retryScheduler(), _headers);
        StackoneMcpDeleteRequest request = buildRequest();

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }
}
