/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class ScreeningResultWebhook {
    /**
     * The event type
     */
    @JsonProperty("event")
    private Event event;

    /**
     * The result data
     */
    @JsonProperty("data")
    private ScreeningResult data;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("raw")
    private JsonNullable<? extends List<RawResponse>> raw;

    @JsonCreator
    public ScreeningResultWebhook(
            @JsonProperty("event") Event event,
            @JsonProperty("data") ScreeningResult data,
            @JsonProperty("raw") JsonNullable<? extends List<RawResponse>> raw) {
        Utils.checkNotNull(event, "event");
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(raw, "raw");
        this.event = event;
        this.data = data;
        this.raw = raw;
    }
    
    public ScreeningResultWebhook(
            Event event,
            ScreeningResult data) {
        this(event, data, JsonNullable.undefined());
    }

    /**
     * The event type
     */
    @JsonIgnore
    public Event event() {
        return event;
    }

    /**
     * The result data
     */
    @JsonIgnore
    public ScreeningResult data() {
        return data;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<RawResponse>> raw() {
        return (JsonNullable<List<RawResponse>>) raw;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The event type
     */
    public ScreeningResultWebhook withEvent(Event event) {
        Utils.checkNotNull(event, "event");
        this.event = event;
        return this;
    }

    /**
     * The result data
     */
    public ScreeningResultWebhook withData(ScreeningResult data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    public ScreeningResultWebhook withRaw(List<RawResponse> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = JsonNullable.of(raw);
        return this;
    }

    public ScreeningResultWebhook withRaw(JsonNullable<? extends List<RawResponse>> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = raw;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ScreeningResultWebhook other = (ScreeningResultWebhook) o;
        return 
            Utils.enhancedDeepEquals(this.event, other.event) &&
            Utils.enhancedDeepEquals(this.data, other.data) &&
            Utils.enhancedDeepEquals(this.raw, other.raw);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            event, data, raw);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ScreeningResultWebhook.class,
                "event", event,
                "data", data,
                "raw", raw);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Event event;

        private ScreeningResult data;

        private JsonNullable<? extends List<RawResponse>> raw = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The event type
         */
        public Builder event(Event event) {
            Utils.checkNotNull(event, "event");
            this.event = event;
            return this;
        }


        /**
         * The result data
         */
        public Builder data(ScreeningResult data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }


        public Builder raw(List<RawResponse> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = JsonNullable.of(raw);
            return this;
        }

        public Builder raw(JsonNullable<? extends List<RawResponse>> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = raw;
            return this;
        }

        public ScreeningResultWebhook build() {

            return new ScreeningResultWebhook(
                event, data, raw);
        }

    }
}
