/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.AtsUpdateApplicationRequestDto;
import com.stackone.stackone_client_java.models.operations.AtsUpdateApplicationRequest;
import com.stackone.stackone_client_java.models.operations.AtsUpdateApplicationResponse;
import com.stackone.stackone_client_java.operations.AtsUpdateApplication;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsUpdateApplicationRequestBuilder {
    private String xAccountId;
    private String id;
    private AtsUpdateApplicationRequestDto atsUpdateApplicationRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public AtsUpdateApplicationRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsUpdateApplicationRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsUpdateApplicationRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsUpdateApplicationRequestBuilder atsUpdateApplicationRequestDto(AtsUpdateApplicationRequestDto atsUpdateApplicationRequestDto) {
        Utils.checkNotNull(atsUpdateApplicationRequestDto, "atsUpdateApplicationRequestDto");
        this.atsUpdateApplicationRequestDto = atsUpdateApplicationRequestDto;
        return this;
    }

    public AtsUpdateApplicationRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsUpdateApplicationRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private AtsUpdateApplicationRequest buildRequest() {
        AtsUpdateApplicationRequest request = new AtsUpdateApplicationRequest(this.xAccountId, this.id, this.atsUpdateApplicationRequestDto);
        return request;
    }

    public AtsUpdateApplicationResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsUpdateApplication.Sync operation = new AtsUpdateApplication.Sync(this.sdkConfiguration, options, this._headers);
        AtsUpdateApplicationRequest request = this.buildRequest();
        return (AtsUpdateApplicationResponse)operation.handleResponse(operation.doRequest(request));
    }
}

