/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.DeleteResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisCancelEmployeeTimeOffRequestResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends DeleteResult> deleteResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisCancelEmployeeTimeOffRequestResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends DeleteResult> deleteResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(deleteResult, "deleteResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.deleteResult = deleteResult;
        this.headers = headers;
    }

    public HrisCancelEmployeeTimeOffRequestResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<DeleteResult> deleteResult() {
        return this.deleteResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisCancelEmployeeTimeOffRequestResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisCancelEmployeeTimeOffRequestResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisCancelEmployeeTimeOffRequestResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisCancelEmployeeTimeOffRequestResponse withDeleteResult(DeleteResult deleteResult) {
        Utils.checkNotNull(deleteResult, "deleteResult");
        this.deleteResult = Optional.ofNullable(deleteResult);
        return this;
    }

    public HrisCancelEmployeeTimeOffRequestResponse withDeleteResult(Optional<? extends DeleteResult> deleteResult) {
        Utils.checkNotNull(deleteResult, "deleteResult");
        this.deleteResult = deleteResult;
        return this;
    }

    public HrisCancelEmployeeTimeOffRequestResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisCancelEmployeeTimeOffRequestResponse other = (HrisCancelEmployeeTimeOffRequestResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.deleteResult, other.deleteResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.deleteResult, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisCancelEmployeeTimeOffRequestResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "deleteResult", this.deleteResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends DeleteResult> deleteResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder deleteResult(DeleteResult deleteResult) {
            Utils.checkNotNull(deleteResult, "deleteResult");
            this.deleteResult = Optional.ofNullable(deleteResult);
            return this;
        }

        public Builder deleteResult(Optional<? extends DeleteResult> deleteResult) {
            Utils.checkNotNull(deleteResult, "deleteResult");
            this.deleteResult = deleteResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisCancelEmployeeTimeOffRequestResponse build() {
            return new HrisCancelEmployeeTimeOffRequestResponse(this.contentType, this.statusCode, this.rawResponse, this.deleteResult, this.headers);
        }
    }
}

