/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * AtsJobValue
 * 
 * <p>The status of the job.
 */
@JsonDeserialize(using = AtsJobValue._Deserializer.class)
@JsonSerialize(using = AtsJobValue._Serializer.class)
public class AtsJobValue {

    public static final AtsJobValue PUBLISHED = new AtsJobValue("published");
    public static final AtsJobValue DRAFT = new AtsJobValue("draft");
    public static final AtsJobValue PENDING = new AtsJobValue("pending");
    public static final AtsJobValue INTERNAL = new AtsJobValue("internal");
    public static final AtsJobValue ARCHIVED = new AtsJobValue("archived");
    public static final AtsJobValue CLOSED = new AtsJobValue("closed");
    public static final AtsJobValue OPEN = new AtsJobValue("open");
    public static final AtsJobValue DELETED = new AtsJobValue("deleted");
    public static final AtsJobValue ON_HOLD = new AtsJobValue("on_hold");
    public static final AtsJobValue UNMAPPED_VALUE = new AtsJobValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AtsJobValue> values = createValuesMap();
    private static final Map<String, AtsJobValueEnum> enums = createEnumsMap();

    private final String value;

    private AtsJobValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AtsJobValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AtsJobValue
     */ 
    public static AtsJobValue of(String value) {
        synchronized (AtsJobValue.class) {
            return values.computeIfAbsent(value, v -> new AtsJobValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<AtsJobValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AtsJobValue other = (AtsJobValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AtsJobValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AtsJobValue[] values() {
        synchronized (AtsJobValue.class) {
            return values.values().toArray(new AtsJobValue[] {});
        }
    }

    private static final Map<String, AtsJobValue> createValuesMap() {
        Map<String, AtsJobValue> map = new LinkedHashMap<>();
        map.put("published", PUBLISHED);
        map.put("draft", DRAFT);
        map.put("pending", PENDING);
        map.put("internal", INTERNAL);
        map.put("archived", ARCHIVED);
        map.put("closed", CLOSED);
        map.put("open", OPEN);
        map.put("deleted", DELETED);
        map.put("on_hold", ON_HOLD);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AtsJobValueEnum> createEnumsMap() {
        Map<String, AtsJobValueEnum> map = new HashMap<>();
        map.put("published", AtsJobValueEnum.PUBLISHED);
        map.put("draft", AtsJobValueEnum.DRAFT);
        map.put("pending", AtsJobValueEnum.PENDING);
        map.put("internal", AtsJobValueEnum.INTERNAL);
        map.put("archived", AtsJobValueEnum.ARCHIVED);
        map.put("closed", AtsJobValueEnum.CLOSED);
        map.put("open", AtsJobValueEnum.OPEN);
        map.put("deleted", AtsJobValueEnum.DELETED);
        map.put("on_hold", AtsJobValueEnum.ON_HOLD);
        map.put("unmapped_value", AtsJobValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<AtsJobValue> {

        protected _Serializer() {
            super(AtsJobValue.class);
        }

        @Override
        public void serialize(AtsJobValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<AtsJobValue> {

        protected _Deserializer() {
            super(AtsJobValue.class);
        }

        @Override
        public AtsJobValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return AtsJobValue.of(v);
        }
    }
    
    public enum AtsJobValueEnum {

        PUBLISHED("published"),
        DRAFT("draft"),
        PENDING("pending"),
        INTERNAL("internal"),
        ARCHIVED("archived"),
        CLOSED("closed"),
        OPEN("open"),
        DELETED("deleted"),
        ON_HOLD("on_hold"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AtsJobValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

