/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.RejectedReasonsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsListRejectedReasonsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends RejectedReasonsPaginated> rejectedReasonsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsListRejectedReasonsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends RejectedReasonsPaginated> rejectedReasonsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(rejectedReasonsPaginated, "rejectedReasonsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.rejectedReasonsPaginated = rejectedReasonsPaginated;
        this.headers = headers;
    }

    public AtsListRejectedReasonsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<RejectedReasonsPaginated> rejectedReasonsPaginated() {
        return this.rejectedReasonsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsListRejectedReasonsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListRejectedReasonsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListRejectedReasonsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListRejectedReasonsResponse withRejectedReasonsPaginated(RejectedReasonsPaginated rejectedReasonsPaginated) {
        Utils.checkNotNull(rejectedReasonsPaginated, "rejectedReasonsPaginated");
        this.rejectedReasonsPaginated = Optional.ofNullable(rejectedReasonsPaginated);
        return this;
    }

    public AtsListRejectedReasonsResponse withRejectedReasonsPaginated(Optional<? extends RejectedReasonsPaginated> rejectedReasonsPaginated) {
        Utils.checkNotNull(rejectedReasonsPaginated, "rejectedReasonsPaginated");
        this.rejectedReasonsPaginated = rejectedReasonsPaginated;
        return this;
    }

    public AtsListRejectedReasonsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListRejectedReasonsResponse other = (AtsListRejectedReasonsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.rejectedReasonsPaginated, other.rejectedReasonsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.rejectedReasonsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListRejectedReasonsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "rejectedReasonsPaginated", this.rejectedReasonsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends RejectedReasonsPaginated> rejectedReasonsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder rejectedReasonsPaginated(RejectedReasonsPaginated rejectedReasonsPaginated) {
            Utils.checkNotNull(rejectedReasonsPaginated, "rejectedReasonsPaginated");
            this.rejectedReasonsPaginated = Optional.ofNullable(rejectedReasonsPaginated);
            return this;
        }

        public Builder rejectedReasonsPaginated(Optional<? extends RejectedReasonsPaginated> rejectedReasonsPaginated) {
            Utils.checkNotNull(rejectedReasonsPaginated, "rejectedReasonsPaginated");
            this.rejectedReasonsPaginated = rejectedReasonsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsListRejectedReasonsResponse build() {
            return new AtsListRejectedReasonsResponse(this.contentType, this.statusCode, this.rawResponse, this.rejectedReasonsPaginated, this.headers);
        }
    }
}

