/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;


public class ProxyResponseApiModel {
    /**
     * The HTTP status code returned by the provider
     */
    @JsonProperty("status")
    private double status;

    /**
     * The headers returned by the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("headers")
    private JsonNullable<? extends Map<String, Object>> headers;

    /**
     * The response data from the provider. Can be an object, array, or primitive value.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("data")
    private JsonNullable<? extends Data> data;

    /**
     * Provider-specific errors if any occurred
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("provider_errors")
    private JsonNullable<? extends List<ProviderErrorApiModel>> providerErrors;

    @JsonCreator
    public ProxyResponseApiModel(
            @JsonProperty("status") double status,
            @JsonProperty("headers") JsonNullable<? extends Map<String, Object>> headers,
            @JsonProperty("data") JsonNullable<? extends Data> data,
            @JsonProperty("provider_errors") JsonNullable<? extends List<ProviderErrorApiModel>> providerErrors) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(headers, "headers");
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(providerErrors, "providerErrors");
        this.status = status;
        this.headers = headers;
        this.data = data;
        this.providerErrors = providerErrors;
    }
    
    public ProxyResponseApiModel(
            double status) {
        this(status, JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * The HTTP status code returned by the provider
     */
    @JsonIgnore
    public double status() {
        return status;
    }

    /**
     * The headers returned by the provider
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> headers() {
        return (JsonNullable<Map<String, Object>>) headers;
    }

    /**
     * The response data from the provider. Can be an object, array, or primitive value.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Data> data() {
        return (JsonNullable<Data>) data;
    }

    /**
     * Provider-specific errors if any occurred
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<ProviderErrorApiModel>> providerErrors() {
        return (JsonNullable<List<ProviderErrorApiModel>>) providerErrors;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The HTTP status code returned by the provider
     */
    public ProxyResponseApiModel withStatus(double status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The headers returned by the provider
     */
    public ProxyResponseApiModel withHeaders(Map<String, Object> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = JsonNullable.of(headers);
        return this;
    }

    /**
     * The headers returned by the provider
     */
    public ProxyResponseApiModel withHeaders(JsonNullable<? extends Map<String, Object>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    /**
     * The response data from the provider. Can be an object, array, or primitive value.
     */
    public ProxyResponseApiModel withData(Data data) {
        Utils.checkNotNull(data, "data");
        this.data = JsonNullable.of(data);
        return this;
    }

    /**
     * The response data from the provider. Can be an object, array, or primitive value.
     */
    public ProxyResponseApiModel withData(JsonNullable<? extends Data> data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    /**
     * Provider-specific errors if any occurred
     */
    public ProxyResponseApiModel withProviderErrors(List<ProviderErrorApiModel> providerErrors) {
        Utils.checkNotNull(providerErrors, "providerErrors");
        this.providerErrors = JsonNullable.of(providerErrors);
        return this;
    }

    /**
     * Provider-specific errors if any occurred
     */
    public ProxyResponseApiModel withProviderErrors(JsonNullable<? extends List<ProviderErrorApiModel>> providerErrors) {
        Utils.checkNotNull(providerErrors, "providerErrors");
        this.providerErrors = providerErrors;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProxyResponseApiModel other = (ProxyResponseApiModel) o;
        return 
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.headers, other.headers) &&
            Utils.enhancedDeepEquals(this.data, other.data) &&
            Utils.enhancedDeepEquals(this.providerErrors, other.providerErrors);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            status, headers, data,
            providerErrors);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ProxyResponseApiModel.class,
                "status", status,
                "headers", headers,
                "data", data,
                "providerErrors", providerErrors);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Double status;

        private JsonNullable<? extends Map<String, Object>> headers = JsonNullable.undefined();

        private JsonNullable<? extends Data> data = JsonNullable.undefined();

        private JsonNullable<? extends List<ProviderErrorApiModel>> providerErrors = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The HTTP status code returned by the provider
         */
        public Builder status(double status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * The headers returned by the provider
         */
        public Builder headers(Map<String, Object> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = JsonNullable.of(headers);
            return this;
        }

        /**
         * The headers returned by the provider
         */
        public Builder headers(JsonNullable<? extends Map<String, Object>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }


        /**
         * The response data from the provider. Can be an object, array, or primitive value.
         */
        public Builder data(Data data) {
            Utils.checkNotNull(data, "data");
            this.data = JsonNullable.of(data);
            return this;
        }

        /**
         * The response data from the provider. Can be an object, array, or primitive value.
         */
        public Builder data(JsonNullable<? extends Data> data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }


        /**
         * Provider-specific errors if any occurred
         */
        public Builder providerErrors(List<ProviderErrorApiModel> providerErrors) {
            Utils.checkNotNull(providerErrors, "providerErrors");
            this.providerErrors = JsonNullable.of(providerErrors);
            return this;
        }

        /**
         * Provider-specific errors if any occurred
         */
        public Builder providerErrors(JsonNullable<? extends List<ProviderErrorApiModel>> providerErrors) {
            Utils.checkNotNull(providerErrors, "providerErrors");
            this.providerErrors = providerErrors;
            return this;
        }

        public ProxyResponseApiModel build() {

            return new ProxyResponseApiModel(
                status, headers, data,
                providerErrors);
        }

    }
}
