/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.BaseCurrency;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class AccountingCompany {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private JsonNullable<String> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="remote_id")
    private JsonNullable<String> remoteId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="name")
    private JsonNullable<String> name;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="base_currency")
    private JsonNullable<? extends BaseCurrency> baseCurrency;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="fiscal_year_start_month")
    private JsonNullable<Double> fiscalYearStartMonth;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="fiscal_year_start_day")
    private JsonNullable<Double> fiscalYearStartDay;

    @JsonCreator
    public AccountingCompany(@JsonProperty(value="id") JsonNullable<String> id, @JsonProperty(value="remote_id") JsonNullable<String> remoteId, @JsonProperty(value="name") JsonNullable<String> name, @JsonProperty(value="base_currency") JsonNullable<? extends BaseCurrency> baseCurrency, @JsonProperty(value="fiscal_year_start_month") JsonNullable<Double> fiscalYearStartMonth, @JsonProperty(value="fiscal_year_start_day") JsonNullable<Double> fiscalYearStartDay) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(baseCurrency, "baseCurrency");
        Utils.checkNotNull(fiscalYearStartMonth, "fiscalYearStartMonth");
        Utils.checkNotNull(fiscalYearStartDay, "fiscalYearStartDay");
        this.id = id;
        this.remoteId = remoteId;
        this.name = name;
        this.baseCurrency = baseCurrency;
        this.fiscalYearStartMonth = fiscalYearStartMonth;
        this.fiscalYearStartDay = fiscalYearStartDay;
    }

    public AccountingCompany() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends BaseCurrency>)JsonNullable.undefined(), (JsonNullable<Double>)JsonNullable.undefined(), (JsonNullable<Double>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> id() {
        return this.id;
    }

    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return this.remoteId;
    }

    @JsonIgnore
    public JsonNullable<String> name() {
        return this.name;
    }

    @JsonIgnore
    public JsonNullable<BaseCurrency> baseCurrency() {
        return this.baseCurrency;
    }

    @JsonIgnore
    public JsonNullable<Double> fiscalYearStartMonth() {
        return this.fiscalYearStartMonth;
    }

    @JsonIgnore
    public JsonNullable<Double> fiscalYearStartDay() {
        return this.fiscalYearStartDay;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AccountingCompany withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of((Object)id);
        return this;
    }

    public AccountingCompany withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AccountingCompany withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of((Object)remoteId);
        return this;
    }

    public AccountingCompany withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public AccountingCompany withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of((Object)name);
        return this;
    }

    public AccountingCompany withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public AccountingCompany withBaseCurrency(BaseCurrency baseCurrency) {
        Utils.checkNotNull(baseCurrency, "baseCurrency");
        this.baseCurrency = JsonNullable.of((Object)baseCurrency);
        return this;
    }

    public AccountingCompany withBaseCurrency(JsonNullable<? extends BaseCurrency> baseCurrency) {
        Utils.checkNotNull(baseCurrency, "baseCurrency");
        this.baseCurrency = baseCurrency;
        return this;
    }

    public AccountingCompany withFiscalYearStartMonth(double fiscalYearStartMonth) {
        Utils.checkNotNull(fiscalYearStartMonth, "fiscalYearStartMonth");
        this.fiscalYearStartMonth = JsonNullable.of((Object)fiscalYearStartMonth);
        return this;
    }

    public AccountingCompany withFiscalYearStartMonth(JsonNullable<Double> fiscalYearStartMonth) {
        Utils.checkNotNull(fiscalYearStartMonth, "fiscalYearStartMonth");
        this.fiscalYearStartMonth = fiscalYearStartMonth;
        return this;
    }

    public AccountingCompany withFiscalYearStartDay(double fiscalYearStartDay) {
        Utils.checkNotNull(fiscalYearStartDay, "fiscalYearStartDay");
        this.fiscalYearStartDay = JsonNullable.of((Object)fiscalYearStartDay);
        return this;
    }

    public AccountingCompany withFiscalYearStartDay(JsonNullable<Double> fiscalYearStartDay) {
        Utils.checkNotNull(fiscalYearStartDay, "fiscalYearStartDay");
        this.fiscalYearStartDay = fiscalYearStartDay;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountingCompany other = (AccountingCompany)o;
        return Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.remoteId, other.remoteId) && Utils.enhancedDeepEquals(this.name, other.name) && Utils.enhancedDeepEquals(this.baseCurrency, other.baseCurrency) && Utils.enhancedDeepEquals(this.fiscalYearStartMonth, other.fiscalYearStartMonth) && Utils.enhancedDeepEquals(this.fiscalYearStartDay, other.fiscalYearStartDay);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.id, this.remoteId, this.name, this.baseCurrency, this.fiscalYearStartMonth, this.fiscalYearStartDay);
    }

    public String toString() {
        return Utils.toString(AccountingCompany.class, "id", this.id, "remoteId", this.remoteId, "name", this.name, "baseCurrency", this.baseCurrency, "fiscalYearStartMonth", this.fiscalYearStartMonth, "fiscalYearStartDay", this.fiscalYearStartDay);
    }

    public static final class Builder {
        private JsonNullable<String> id = JsonNullable.undefined();
        private JsonNullable<String> remoteId = JsonNullable.undefined();
        private JsonNullable<String> name = JsonNullable.undefined();
        private JsonNullable<? extends BaseCurrency> baseCurrency = JsonNullable.undefined();
        private JsonNullable<Double> fiscalYearStartMonth = JsonNullable.undefined();
        private JsonNullable<Double> fiscalYearStartDay = JsonNullable.undefined();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of((Object)id);
            return this;
        }

        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of((Object)remoteId);
            return this;
        }

        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of((Object)name);
            return this;
        }

        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder baseCurrency(BaseCurrency baseCurrency) {
            Utils.checkNotNull(baseCurrency, "baseCurrency");
            this.baseCurrency = JsonNullable.of((Object)baseCurrency);
            return this;
        }

        public Builder baseCurrency(JsonNullable<? extends BaseCurrency> baseCurrency) {
            Utils.checkNotNull(baseCurrency, "baseCurrency");
            this.baseCurrency = baseCurrency;
            return this;
        }

        public Builder fiscalYearStartMonth(double fiscalYearStartMonth) {
            Utils.checkNotNull(fiscalYearStartMonth, "fiscalYearStartMonth");
            this.fiscalYearStartMonth = JsonNullable.of((Object)fiscalYearStartMonth);
            return this;
        }

        public Builder fiscalYearStartMonth(JsonNullable<Double> fiscalYearStartMonth) {
            Utils.checkNotNull(fiscalYearStartMonth, "fiscalYearStartMonth");
            this.fiscalYearStartMonth = fiscalYearStartMonth;
            return this;
        }

        public Builder fiscalYearStartDay(double fiscalYearStartDay) {
            Utils.checkNotNull(fiscalYearStartDay, "fiscalYearStartDay");
            this.fiscalYearStartDay = JsonNullable.of((Object)fiscalYearStartDay);
            return this;
        }

        public Builder fiscalYearStartDay(JsonNullable<Double> fiscalYearStartDay) {
            Utils.checkNotNull(fiscalYearStartDay, "fiscalYearStartDay");
            this.fiscalYearStartDay = fiscalYearStartDay;
            return this;
        }

        public AccountingCompany build() {
            return new AccountingCompany(this.id, this.remoteId, this.name, this.baseCurrency, this.fiscalYearStartMonth, this.fiscalYearStartDay);
        }
    }
}

