/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.HrisListPositionsRequest;
import com.stackone.stackone_client_java.models.operations.HrisListPositionsResponse;
import com.stackone.stackone_client_java.operations.HrisListPositions;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class HrisListPositionsRequestBuilder {
    private HrisListPositionsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public HrisListPositionsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public HrisListPositionsRequestBuilder request(HrisListPositionsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public HrisListPositionsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisListPositionsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public HrisListPositionsResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListPositions.Sync operation = new HrisListPositions.Sync(this.sdkConfiguration, options, this._headers);
        return (HrisListPositionsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<HrisListPositionsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListPositions.Sync operation = new HrisListPositions.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<HrisListPositionsRequest, String> iterator = new Paginator<HrisListPositionsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), HrisListPositionsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<HrisListPositionsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

