/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.stackone.stackone_client_java.utils.BigDecimalString;
import com.stackone.stackone_client_java.utils.BigIntegerString;
import com.stackone.stackone_client_java.utils.JSON;
import com.stackone.stackone_client_java.utils.TypedObject;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OneOfDeserializer<T>
extends StdDeserializer<T> {
    private static final long serialVersionUID = -1L;
    private final transient List<Utils.TypeReferenceWithShape> typeReferences;
    private final Class<T> cls;
    private final ObjectMapper mapper;
    private static final Set<String> NUMERIC_CLASSES = Set.of(Integer.class.getCanonicalName(), Long.class.getCanonicalName(), BigInteger.class.getCanonicalName(), Float.class.getCanonicalName(), Double.class.getCanonicalName(), BigDecimal.class.getCanonicalName());
    private static final Set<String> DECIMAL_CLASSES = Set.of(Float.class.getCanonicalName(), Double.class.getCanonicalName(), BigDecimal.class.getCanonicalName());
    private static final Set<String> INTEGER_CLASSES = Set.of(Integer.class.getCanonicalName(), Long.class.getCanonicalName(), BigInteger.class.getCanonicalName());
    private static final Set<String> DATE_TIME_CLASSES = Set.of(OffsetDateTime.class.getCanonicalName(), LocalDate.class.getCanonicalName());

    protected OneOfDeserializer(Class<T> cls, boolean strict, Utils.TypeReferenceWithShape ... typeReferences) {
        super(cls);
        this.typeReferences = Arrays.asList(typeReferences);
        this.cls = cls;
        this.mapper = JSON.getMapper();
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        TreeNode tree = p.getCodec().readTree(p);
        return OneOfDeserializer.deserializeOneOf(this.mapper, tree, this.typeReferences, this.cls);
    }

    private static <T> T deserializeOneOf(ObjectMapper mapper, TreeNode tree, List<Utils.TypeReferenceWithShape> typeReferences, Class<T> cls) throws JsonProcessingException {
        String json = mapper.writeValueAsString((Object)tree);
        List<Match<T>> matches = new ArrayList<Match<T>>();
        for (Utils.TypeReferenceWithShape c : typeReferences) {
            try {
                JavaType jt = Utils.convertToShape(mapper.getTypeFactory(), c.typeReference(), c.shape());
                if (!OneOfDeserializer.matchPossible(jt, json)) continue;
                Object o = mapper.readValue(json, jt);
                o = Utils.convertToShapeInverse(o, c.shape(), jt);
                TypedObject typed = TypedObject.of(o, c.shape(), c.typeReference());
                T v = OneOfDeserializer.newInstance(cls, typed);
                matches.add(new Match<T>(c, v, tree));
            }
            catch (DatabindException databindException) {}
        }
        if (matches.size() == 1) {
            return ((Match)matches.get((int)0)).value;
        }
        if (!(matches = OneOfDeserializer.applyMatchPreferences(matches, json)).isEmpty()) {
            return matches.get((int)0).value;
        }
        JsonNode node = tree instanceof JsonNode ? (JsonNode)tree : mapper.readTree(json);
        TypedObject typed = TypedObject.of(node, Utils.JsonShape.DEFAULT, new TypeReference<JsonNode>(){});
        return OneOfDeserializer.newInstance(cls, typed);
    }

    private static Object unwrapValue(Object wrapper) {
        if (wrapper == null) {
            return null;
        }
        try {
            for (Field field : wrapper.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(JsonValue.class)) continue;
                field.setAccessible(true);
                Object fieldValue = field.get(wrapper);
                if (fieldValue instanceof TypedObject) {
                    return ((TypedObject)fieldValue).value();
                }
                return fieldValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wrapper;
    }

    private static int countMatching(Object obj, JsonNode jsonNode, ObjectMatcher matcher) {
        if (obj == null || jsonNode == null) {
            return 0;
        }
        if (matcher.test(obj, jsonNode)) {
            return 1;
        }
        if (OneOfDeserializer.isPrimitiveOrString(obj)) {
            return 0;
        }
        try {
            if (obj instanceof Collection && jsonNode.isArray()) {
                int count = 0;
                int index = 0;
                for (Object element : (Collection)obj) {
                    if (element != null && index < jsonNode.size()) {
                        JsonNode elementNode = jsonNode.get(index);
                        count += OneOfDeserializer.countMatching(element, elementNode, matcher);
                    }
                    ++index;
                }
                return count;
            }
            if (obj instanceof Map && jsonNode.isObject()) {
                int count = 0;
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    String key;
                    if (entry.getKey() == null || entry.getValue() == null || !jsonNode.has(key = entry.getKey().toString())) continue;
                    JsonNode valueNode = jsonNode.get(key);
                    count += OneOfDeserializer.countMatching(entry.getValue(), valueNode, matcher);
                }
                return count;
            }
            if (jsonNode.isObject() && !(obj instanceof Map)) {
                int count = 0;
                for (Field field : obj.getClass().getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    field.setAccessible(true);
                    Object fieldValue = field.get(obj);
                    String fieldName = field.getName();
                    if (fieldValue == null || !jsonNode.has(fieldName)) continue;
                    JsonNode fieldNode = jsonNode.get(fieldName);
                    count += OneOfDeserializer.countMatching(fieldValue, fieldNode, matcher);
                }
                return count;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int countMappedFields(Object obj, JsonNode jsonNode) {
        return OneOfDeserializer.countMatching(obj, jsonNode, (o, ignored) -> OneOfDeserializer.isPrimitiveOrString(o));
    }

    private static int countMappedEnumFields(Object obj, JsonNode jsonNode) {
        return OneOfDeserializer.countMatching(obj, jsonNode, (o, node) -> {
            if (!o.getClass().isEnum()) {
                return false;
            }
            if (node != null && node.isTextual()) {
                String enumValue = ((Enum)o).name();
                String jsonValue = node.asText();
                return enumValue.equals(jsonValue);
            }
            return false;
        });
    }

    private static boolean isPrimitiveOrString(Object obj) {
        Class<?> clazz = obj.getClass();
        return clazz.isPrimitive() || clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Boolean.class || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == OffsetDateTime.class || clazz == LocalDate.class;
    }

    public static boolean matchPossible(JavaType type, String json) {
        if (OneOfDeserializer.typeIs(type, String.class) || OneOfDeserializer.typeIs(type, BigIntegerString.class) || OneOfDeserializer.typeIs(type, BigDecimalString.class)) {
            return OneOfDeserializer.isDoubleQuoted(json);
        }
        if (OneOfDeserializer.typeIs(type, Boolean.class)) {
            return json.equals("true") || json.equals("false");
        }
        if (NUMERIC_CLASSES.contains(type.getTypeName())) {
            return !json.contains("\"");
        }
        if (OneOfDeserializer.typeIs(type, OffsetDateTime.class) || OneOfDeserializer.typeIs(type, LocalDate.class)) {
            return OneOfDeserializer.isDoubleQuoted(json) && !OneOfDeserializer.isNumeric(json.substring(1, json.length() - 1));
        }
        return true;
    }

    private static boolean isDoubleQuoted(String s) {
        return s.length() >= 2 && s.startsWith("\"") && s.endsWith("\"");
    }

    public static <T> List<Match<T>> applyMatchPreferences(List<Match<T>> matches, String json) {
        if (matches.size() <= 1) {
            return matches;
        }
        if (OneOfDeserializer.allNumeric(matches)) {
            List<Match<T>> decimalMatches = OneOfDeserializer.decimalMatches(matches);
            List<Match<T>> integerMatches = OneOfDeserializer.integerMatches(matches);
            matches = !decimalMatches.isEmpty() && !integerMatches.isEmpty() ? (json.contains("e") || json.contains(".") ? decimalMatches : integerMatches) : (!decimalMatches.isEmpty() ? decimalMatches : integerMatches);
        } else if (OneOfDeserializer.allDateTime(matches)) {
            List<Match<T>> list = matches = json.contains("T") ? OneOfDeserializer.filter(matches, OffsetDateTime.class) : OneOfDeserializer.filter(matches, LocalDate.class);
        }
        if (matches.size() > 1) {
            return matches.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        }
        return matches;
    }

    private static <T> List<Match<T>> filter(List<Match<T>> matches, Class<?> filterByClass) {
        return matches.stream().filter(x -> x.typeReference.typeReference().getType().getTypeName().equals(filterByClass.getCanonicalName())).collect(Collectors.toList());
    }

    private static <T> boolean allDateTime(List<Match<T>> matches) {
        return matches.stream().allMatch(x -> DATE_TIME_CLASSES.contains(x.typeReference.typeReference().getType().getTypeName()));
    }

    private static <T> boolean allNumeric(List<Match<T>> matches) {
        return matches.stream().allMatch(x -> NUMERIC_CLASSES.contains(x.typeReference.typeReference().getType().getTypeName()));
    }

    private static <T> List<Match<T>> decimalMatches(List<Match<T>> matches) {
        return matches.stream().filter(x -> DECIMAL_CLASSES.contains(x.typeReference.typeReference().getType().getTypeName())).collect(Collectors.toList());
    }

    private static <T> List<Match<T>> integerMatches(List<Match<T>> matches) {
        return matches.stream().filter(x -> INTEGER_CLASSES.contains(x.typeReference.typeReference().getType().getTypeName())).collect(Collectors.toList());
    }

    private static boolean isNumeric(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean typeIs(JavaType type, Class<?> cls) {
        return type.getRawClass().equals(cls);
    }

    private static <T> String typeNames(List<Match<T>> matches) {
        return "[" + matches.stream().map(x -> x.typeReference.typeReference().getType().getTypeName()).collect(Collectors.joining(", ")) + "]";
    }

    private static String typeReferenceNames(List<Utils.TypeReferenceWithShape> list) {
        return "[" + list.stream().map(x -> x.typeReference().getType().getTypeName()).collect(Collectors.joining(", ")) + "]";
    }

    private static <T> T newInstance(Class<T> cls, Object parameter) {
        try {
            Constructor<T> con = cls.getDeclaredConstructor(TypedObject.class);
            con.setAccessible(true);
            return con.newInstance(parameter);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    private static interface ObjectMatcher {
        public boolean test(Object var1, JsonNode var2);
    }

    private static final class Match<T>
    implements Comparable<Match<T>> {
        final Utils.TypeReferenceWithShape typeReference;
        final T value;
        private final TreeNode tree;

        Match(Utils.TypeReferenceWithShape typeReference, T value, TreeNode tree) {
            this.typeReference = typeReference;
            this.value = value;
            this.tree = tree;
        }

        private int getMappedFields() {
            try {
                Object unwrapped = OneOfDeserializer.unwrapValue(this.value);
                JsonNode jsonNode = this.tree instanceof JsonNode ? (JsonNode)this.tree : null;
                return jsonNode != null ? OneOfDeserializer.countMappedFields(unwrapped, jsonNode) : 0;
            }
            catch (Exception e) {
                return 0;
            }
        }

        private int getMappedEnumFields() {
            try {
                Object unwrapped = OneOfDeserializer.unwrapValue(this.value);
                JsonNode jsonNode = this.tree instanceof JsonNode ? (JsonNode)this.tree : null;
                return jsonNode != null ? OneOfDeserializer.countMappedEnumFields(unwrapped, jsonNode) : 0;
            }
            catch (Exception e) {
                return 0;
            }
        }

        @Override
        public int compareTo(Match<T> other) {
            int fieldComparison = Integer.compare(this.getMappedFields(), other.getMappedFields());
            if (fieldComparison != 0) {
                return fieldComparison;
            }
            int enumFieldComparison = Integer.compare(this.getMappedEnumFields(), other.getMappedEnumFields());
            if (enumFieldComparison != 0) {
                return enumFieldComparison;
            }
            try {
                String thisJson = JSON.getMapper().writeValueAsString(OneOfDeserializer.unwrapValue(this.value));
                String otherJson = JSON.getMapper().writeValueAsString(OneOfDeserializer.unwrapValue(other.value));
                return Integer.compare(thisJson.length(), otherJson.length());
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

