/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.UnifiedUploadRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class DocumentsUploadFileRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * The session token
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-stackone-api-session-token")
    private Optional<String> xStackoneApiSessionToken;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private UnifiedUploadRequestDto unifiedUploadRequestDto;

    @JsonCreator
    public DocumentsUploadFileRequest(
            String xAccountId,
            Optional<String> xStackoneApiSessionToken,
            UnifiedUploadRequestDto unifiedUploadRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        Utils.checkNotNull(unifiedUploadRequestDto, "unifiedUploadRequestDto");
        this.xAccountId = xAccountId;
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        this.unifiedUploadRequestDto = unifiedUploadRequestDto;
    }
    
    public DocumentsUploadFileRequest(
            String xAccountId,
            UnifiedUploadRequestDto unifiedUploadRequestDto) {
        this(xAccountId, Optional.empty(), unifiedUploadRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * The session token
     */
    @JsonIgnore
    public Optional<String> xStackoneApiSessionToken() {
        return xStackoneApiSessionToken;
    }

    @JsonIgnore
    public UnifiedUploadRequestDto unifiedUploadRequestDto() {
        return unifiedUploadRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public DocumentsUploadFileRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * The session token
     */
    public DocumentsUploadFileRequest withXStackoneApiSessionToken(String xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = Optional.ofNullable(xStackoneApiSessionToken);
        return this;
    }


    /**
     * The session token
     */
    public DocumentsUploadFileRequest withXStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        return this;
    }

    public DocumentsUploadFileRequest withUnifiedUploadRequestDto(UnifiedUploadRequestDto unifiedUploadRequestDto) {
        Utils.checkNotNull(unifiedUploadRequestDto, "unifiedUploadRequestDto");
        this.unifiedUploadRequestDto = unifiedUploadRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DocumentsUploadFileRequest other = (DocumentsUploadFileRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.xStackoneApiSessionToken, other.xStackoneApiSessionToken) &&
            Utils.enhancedDeepEquals(this.unifiedUploadRequestDto, other.unifiedUploadRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, xStackoneApiSessionToken, unifiedUploadRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(DocumentsUploadFileRequest.class,
                "xAccountId", xAccountId,
                "xStackoneApiSessionToken", xStackoneApiSessionToken,
                "unifiedUploadRequestDto", unifiedUploadRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> xStackoneApiSessionToken = Optional.empty();

        private UnifiedUploadRequestDto unifiedUploadRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * The session token
         */
        public Builder xStackoneApiSessionToken(String xStackoneApiSessionToken) {
            Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
            this.xStackoneApiSessionToken = Optional.ofNullable(xStackoneApiSessionToken);
            return this;
        }

        /**
         * The session token
         */
        public Builder xStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
            Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
            this.xStackoneApiSessionToken = xStackoneApiSessionToken;
            return this;
        }


        public Builder unifiedUploadRequestDto(UnifiedUploadRequestDto unifiedUploadRequestDto) {
            Utils.checkNotNull(unifiedUploadRequestDto, "unifiedUploadRequestDto");
            this.unifiedUploadRequestDto = unifiedUploadRequestDto;
            return this;
        }

        public DocumentsUploadFileRequest build() {

            return new DocumentsUploadFileRequest(
                xAccountId, xStackoneApiSessionToken, unifiedUploadRequestDto);
        }

    }
}
