/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HRISGroupsResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisGetGroupResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends HRISGroupsResult> hrisGroupsResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisGetGroupResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends HRISGroupsResult> hrisGroupsResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisGroupsResult, "hrisGroupsResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisGroupsResult = hrisGroupsResult;
        this.headers = headers;
    }

    public HrisGetGroupResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HRISGroupsResult> hrisGroupsResult() {
        return this.hrisGroupsResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisGetGroupResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisGetGroupResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisGetGroupResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisGetGroupResponse withHRISGroupsResult(HRISGroupsResult hrisGroupsResult) {
        Utils.checkNotNull(hrisGroupsResult, "hrisGroupsResult");
        this.hrisGroupsResult = Optional.ofNullable(hrisGroupsResult);
        return this;
    }

    public HrisGetGroupResponse withHRISGroupsResult(Optional<? extends HRISGroupsResult> hrisGroupsResult) {
        Utils.checkNotNull(hrisGroupsResult, "hrisGroupsResult");
        this.hrisGroupsResult = hrisGroupsResult;
        return this;
    }

    public HrisGetGroupResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisGetGroupResponse other = (HrisGetGroupResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.hrisGroupsResult, other.hrisGroupsResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.hrisGroupsResult, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisGetGroupResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisGroupsResult", this.hrisGroupsResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends HRISGroupsResult> hrisGroupsResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisGroupsResult(HRISGroupsResult hrisGroupsResult) {
            Utils.checkNotNull(hrisGroupsResult, "hrisGroupsResult");
            this.hrisGroupsResult = Optional.ofNullable(hrisGroupsResult);
            return this;
        }

        public Builder hrisGroupsResult(Optional<? extends HRISGroupsResult> hrisGroupsResult) {
            Utils.checkNotNull(hrisGroupsResult, "hrisGroupsResult");
            this.hrisGroupsResult = hrisGroupsResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisGetGroupResponse build() {
            return new HrisGetGroupResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisGroupsResult, this.headers);
        }
    }
}

