/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingTicketResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TicketingGetTicketResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends TicketingTicketResult> ticketingTicketResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public TicketingGetTicketResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends TicketingTicketResult> ticketingTicketResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(ticketingTicketResult, "ticketingTicketResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.ticketingTicketResult = ticketingTicketResult;
        this.headers = headers;
    }

    public TicketingGetTicketResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TicketingTicketResult> ticketingTicketResult() {
        return this.ticketingTicketResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TicketingGetTicketResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public TicketingGetTicketResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public TicketingGetTicketResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public TicketingGetTicketResponse withTicketingTicketResult(TicketingTicketResult ticketingTicketResult) {
        Utils.checkNotNull(ticketingTicketResult, "ticketingTicketResult");
        this.ticketingTicketResult = Optional.ofNullable(ticketingTicketResult);
        return this;
    }

    public TicketingGetTicketResponse withTicketingTicketResult(Optional<? extends TicketingTicketResult> ticketingTicketResult) {
        Utils.checkNotNull(ticketingTicketResult, "ticketingTicketResult");
        this.ticketingTicketResult = ticketingTicketResult;
        return this;
    }

    public TicketingGetTicketResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketingGetTicketResponse other = (TicketingGetTicketResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.ticketingTicketResult, other.ticketingTicketResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.ticketingTicketResult, this.headers);
    }

    public String toString() {
        return Utils.toString(TicketingGetTicketResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "ticketingTicketResult", this.ticketingTicketResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends TicketingTicketResult> ticketingTicketResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder ticketingTicketResult(TicketingTicketResult ticketingTicketResult) {
            Utils.checkNotNull(ticketingTicketResult, "ticketingTicketResult");
            this.ticketingTicketResult = Optional.ofNullable(ticketingTicketResult);
            return this;
        }

        public Builder ticketingTicketResult(Optional<? extends TicketingTicketResult> ticketingTicketResult) {
            Utils.checkNotNull(ticketingTicketResult, "ticketingTicketResult");
            this.ticketingTicketResult = ticketingTicketResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public TicketingGetTicketResponse build() {
            return new TicketingGetTicketResponse(this.contentType, this.statusCode, this.rawResponse, this.ticketingTicketResult, this.headers);
        }
    }
}

