/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * HrisJobStatus
 * 
 * <p>Status of the job
 */
public class HrisJobStatus {
    /**
     * The status of the job.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends HrisJobValue> value;

    /**
     * The source value of the job status.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends HrisJobSourceValue> sourceValue;

    @JsonCreator
    public HrisJobStatus(
            @JsonProperty("value") JsonNullable<? extends HrisJobValue> value,
            @JsonProperty("source_value") JsonNullable<? extends HrisJobSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public HrisJobStatus() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The status of the job.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisJobValue> value() {
        return (JsonNullable<HrisJobValue>) value;
    }

    /**
     * The source value of the job status.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisJobSourceValue> sourceValue() {
        return (JsonNullable<HrisJobSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The status of the job.
     */
    public HrisJobStatus withValue(HrisJobValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The status of the job.
     */
    public HrisJobStatus withValue(JsonNullable<? extends HrisJobValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the job status.
     */
    public HrisJobStatus withSourceValue(HrisJobSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the job status.
     */
    public HrisJobStatus withSourceValue(JsonNullable<? extends HrisJobSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisJobStatus other = (HrisJobStatus) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisJobStatus.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends HrisJobValue> value = JsonNullable.undefined();

        private JsonNullable<? extends HrisJobSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The status of the job.
         */
        public Builder value(HrisJobValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The status of the job.
         */
        public Builder value(JsonNullable<? extends HrisJobValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        /**
         * The source value of the job status.
         */
        public Builder sourceValue(HrisJobSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the job status.
         */
        public Builder sourceValue(JsonNullable<? extends HrisJobSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public HrisJobStatus build() {

            return new HrisJobStatus(
                value, sourceValue);
        }

    }
}
