/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class JobPostingCompensationValue {
    public static final JobPostingCompensationValue SALARY = new JobPostingCompensationValue("salary");
    public static final JobPostingCompensationValue HOURLY = new JobPostingCompensationValue("hourly");
    public static final JobPostingCompensationValue COMMISSION = new JobPostingCompensationValue("commission");
    public static final JobPostingCompensationValue BONUS = new JobPostingCompensationValue("bonus");
    public static final JobPostingCompensationValue EQUITY = new JobPostingCompensationValue("equity");
    public static final JobPostingCompensationValue OTHER = new JobPostingCompensationValue("other");
    public static final JobPostingCompensationValue UNMAPPED_VALUE = new JobPostingCompensationValue("unmapped_value");
    private static final Map<String, JobPostingCompensationValue> values = JobPostingCompensationValue.createValuesMap();
    private static final Map<String, JobPostingCompensationValueEnum> enums = JobPostingCompensationValue.createEnumsMap();
    private final String value;

    private JobPostingCompensationValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobPostingCompensationValue of(String value) {
        Class<JobPostingCompensationValue> clazz = JobPostingCompensationValue.class;
        synchronized (JobPostingCompensationValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new JobPostingCompensationValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<JobPostingCompensationValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobPostingCompensationValue other = (JobPostingCompensationValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "JobPostingCompensationValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobPostingCompensationValue[] values() {
        Class<JobPostingCompensationValue> clazz = JobPostingCompensationValue.class;
        synchronized (JobPostingCompensationValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new JobPostingCompensationValue[0]);
        }
    }

    private static final Map<String, JobPostingCompensationValue> createValuesMap() {
        LinkedHashMap<String, JobPostingCompensationValue> map = new LinkedHashMap<String, JobPostingCompensationValue>();
        map.put("salary", SALARY);
        map.put("hourly", HOURLY);
        map.put("commission", COMMISSION);
        map.put("bonus", BONUS);
        map.put("equity", EQUITY);
        map.put("other", OTHER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, JobPostingCompensationValueEnum> createEnumsMap() {
        HashMap<String, JobPostingCompensationValueEnum> map = new HashMap<String, JobPostingCompensationValueEnum>();
        map.put("salary", JobPostingCompensationValueEnum.SALARY);
        map.put("hourly", JobPostingCompensationValueEnum.HOURLY);
        map.put("commission", JobPostingCompensationValueEnum.COMMISSION);
        map.put("bonus", JobPostingCompensationValueEnum.BONUS);
        map.put("equity", JobPostingCompensationValueEnum.EQUITY);
        map.put("other", JobPostingCompensationValueEnum.OTHER);
        map.put("unmapped_value", JobPostingCompensationValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum JobPostingCompensationValueEnum {
        SALARY("salary"),
        HOURLY("hourly"),
        COMMISSION("commission"),
        BONUS("bonus"),
        EQUITY("equity"),
        OTHER("other"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private JobPostingCompensationValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<JobPostingCompensationValue> {
        protected _Deserializer() {
            super(JobPostingCompensationValue.class);
        }

        public JobPostingCompensationValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return JobPostingCompensationValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<JobPostingCompensationValue> {
        protected _Serializer() {
            super(JobPostingCompensationValue.class);
        }

        public void serialize(JobPostingCompensationValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

