/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class MessageValue {
    public static final MessageValue EMAIL = new MessageValue("email");
    public static final MessageValue SMS = new MessageValue("sms");
    public static final MessageValue PUSH = new MessageValue("push");
    public static final MessageValue WEB_PUSH = new MessageValue("web_push");
    public static final MessageValue IOS_PUSH = new MessageValue("ios_push");
    public static final MessageValue ANDROID_PUSH = new MessageValue("android_push");
    public static final MessageValue APP_PUSH = new MessageValue("app_push");
    public static final MessageValue OMNI_CHANNEL = new MessageValue("omni_channel");
    public static final MessageValue CONTENT_BLOCK = new MessageValue("content_block");
    public static final MessageValue IN_APP = new MessageValue("in_app");
    public static final MessageValue UNKNOWN = new MessageValue("unknown");
    public static final MessageValue UNMAPPED_VALUE = new MessageValue("unmapped_value");
    private static final Map<String, MessageValue> values = MessageValue.createValuesMap();
    private static final Map<String, MessageValueEnum> enums = MessageValue.createEnumsMap();
    private final String value;

    private MessageValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageValue of(String value) {
        Class<MessageValue> clazz = MessageValue.class;
        synchronized (MessageValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new MessageValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<MessageValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageValue other = (MessageValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "MessageValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageValue[] values() {
        Class<MessageValue> clazz = MessageValue.class;
        synchronized (MessageValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new MessageValue[0]);
        }
    }

    private static final Map<String, MessageValue> createValuesMap() {
        LinkedHashMap<String, MessageValue> map = new LinkedHashMap<String, MessageValue>();
        map.put("email", EMAIL);
        map.put("sms", SMS);
        map.put("push", PUSH);
        map.put("web_push", WEB_PUSH);
        map.put("ios_push", IOS_PUSH);
        map.put("android_push", ANDROID_PUSH);
        map.put("app_push", APP_PUSH);
        map.put("omni_channel", OMNI_CHANNEL);
        map.put("content_block", CONTENT_BLOCK);
        map.put("in_app", IN_APP);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, MessageValueEnum> createEnumsMap() {
        HashMap<String, MessageValueEnum> map = new HashMap<String, MessageValueEnum>();
        map.put("email", MessageValueEnum.EMAIL);
        map.put("sms", MessageValueEnum.SMS);
        map.put("push", MessageValueEnum.PUSH);
        map.put("web_push", MessageValueEnum.WEB_PUSH);
        map.put("ios_push", MessageValueEnum.IOS_PUSH);
        map.put("android_push", MessageValueEnum.ANDROID_PUSH);
        map.put("app_push", MessageValueEnum.APP_PUSH);
        map.put("omni_channel", MessageValueEnum.OMNI_CHANNEL);
        map.put("content_block", MessageValueEnum.CONTENT_BLOCK);
        map.put("in_app", MessageValueEnum.IN_APP);
        map.put("unknown", MessageValueEnum.UNKNOWN);
        map.put("unmapped_value", MessageValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum MessageValueEnum {
        EMAIL("email"),
        SMS("sms"),
        PUSH("push"),
        WEB_PUSH("web_push"),
        IOS_PUSH("ios_push"),
        ANDROID_PUSH("android_push"),
        APP_PUSH("app_push"),
        OMNI_CHANNEL("omni_channel"),
        CONTENT_BLOCK("content_block"),
        IN_APP("in_app"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private MessageValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<MessageValue> {
        protected _Deserializer() {
            super(MessageValue.class);
        }

        public MessageValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return MessageValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<MessageValue> {
        protected _Serializer() {
            super(MessageValue.class);
        }

        public void serialize(MessageValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

