/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class SocialLink {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="type")
    private JsonNullable<String> type;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="url")
    private JsonNullable<String> url;

    @JsonCreator
    public SocialLink(@JsonProperty(value="type") JsonNullable<String> type, @JsonProperty(value="url") JsonNullable<String> url) {
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(url, "url");
        this.type = type;
        this.url = url;
    }

    public SocialLink() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> type() {
        return this.type;
    }

    @JsonIgnore
    public JsonNullable<String> url() {
        return this.url;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SocialLink withType(String type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of((Object)type);
        return this;
    }

    public SocialLink withType(JsonNullable<String> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    public SocialLink withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of((Object)url);
        return this;
    }

    public SocialLink withUrl(JsonNullable<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocialLink other = (SocialLink)o;
        return Utils.enhancedDeepEquals(this.type, other.type) && Utils.enhancedDeepEquals(this.url, other.url);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.type, this.url);
    }

    public String toString() {
        return Utils.toString(SocialLink.class, "type", this.type, "url", this.url);
    }

    public static final class Builder {
        private JsonNullable<String> type = JsonNullable.undefined();
        private JsonNullable<String> url = JsonNullable.undefined();

        private Builder() {
        }

        public Builder type(String type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of((Object)type);
            return this;
        }

        public Builder type(JsonNullable<String> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of((Object)url);
            return this;
        }

        public Builder url(JsonNullable<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        public SocialLink build() {
            return new SocialLink(this.type, this.url);
        }
    }
}

