/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.AtsListDepartmentsRequest;
import com.stackone.stackone_client_java.models.operations.AtsListDepartmentsResponse;
import com.stackone.stackone_client_java.operations.AtsListDepartments;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class AtsListDepartmentsRequestBuilder {
    private AtsListDepartmentsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public AtsListDepartmentsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsListDepartmentsRequestBuilder request(AtsListDepartmentsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public AtsListDepartmentsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsListDepartmentsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public AtsListDepartmentsResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListDepartments.Sync operation = new AtsListDepartments.Sync(this.sdkConfiguration, options, this._headers);
        return (AtsListDepartmentsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<AtsListDepartmentsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListDepartments.Sync operation = new AtsListDepartments.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<AtsListDepartmentsRequest, String> iterator = new Paginator<AtsListDepartmentsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), AtsListDepartmentsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<AtsListDepartmentsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

