/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingUserResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TicketingGetUserResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends TicketingUserResult> ticketingUserResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public TicketingGetUserResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends TicketingUserResult> ticketingUserResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(ticketingUserResult, "ticketingUserResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.ticketingUserResult = ticketingUserResult;
        this.headers = headers;
    }

    public TicketingGetUserResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TicketingUserResult> ticketingUserResult() {
        return this.ticketingUserResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TicketingGetUserResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public TicketingGetUserResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public TicketingGetUserResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public TicketingGetUserResponse withTicketingUserResult(TicketingUserResult ticketingUserResult) {
        Utils.checkNotNull(ticketingUserResult, "ticketingUserResult");
        this.ticketingUserResult = Optional.ofNullable(ticketingUserResult);
        return this;
    }

    public TicketingGetUserResponse withTicketingUserResult(Optional<? extends TicketingUserResult> ticketingUserResult) {
        Utils.checkNotNull(ticketingUserResult, "ticketingUserResult");
        this.ticketingUserResult = ticketingUserResult;
        return this;
    }

    public TicketingGetUserResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketingGetUserResponse other = (TicketingGetUserResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.ticketingUserResult, other.ticketingUserResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.ticketingUserResult, this.headers);
    }

    public String toString() {
        return Utils.toString(TicketingGetUserResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "ticketingUserResult", this.ticketingUserResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends TicketingUserResult> ticketingUserResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder ticketingUserResult(TicketingUserResult ticketingUserResult) {
            Utils.checkNotNull(ticketingUserResult, "ticketingUserResult");
            this.ticketingUserResult = Optional.ofNullable(ticketingUserResult);
            return this;
        }

        public Builder ticketingUserResult(Optional<? extends TicketingUserResult> ticketingUserResult) {
            Utils.checkNotNull(ticketingUserResult, "ticketingUserResult");
            this.ticketingUserResult = ticketingUserResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public TicketingGetUserResponse build() {
            return new TicketingGetUserResponse(this.contentType, this.statusCode, this.rawResponse, this.ticketingUserResult, this.headers);
        }
    }
}

