/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.stackone.stackone_client_java.utils.AsyncHook;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Hook;
import com.stackone.stackone_client_java.utils.ResponseWithBody;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public final class HookAdapters {
    private HookAdapters() {
    }

    public static AsyncHook.BeforeRequest toAsync(Hook.BeforeRequest beforeRequestHook) {
        return (context, request) -> CompletableFuture.supplyAsync(() -> Exceptions.unchecked(() -> beforeRequestHook.beforeRequest(context, request)).get());
    }

    public static AsyncHook.AfterError toAsync(Hook.AfterError afterErrorHook) {
        return (context, response, error) -> HookAdapters.toStreamResponse(response).thenCompose(backCompatResp -> {
            CompletableFuture<HttpResponse> processedResp = CompletableFuture.supplyAsync(() -> Exceptions.unchecked(() -> afterErrorHook.afterError(context, Optional.of(backCompatResp), Optional.of(Exceptions.coerceException(error)))).get());
            return processedResp.thenApply(HookAdapters::toBlobResponse);
        });
    }

    public static AsyncHook.AfterSuccess toAsync(Hook.AfterSuccess afterSuccessHook) {
        return (context, response) -> HookAdapters.toStreamResponse(response).thenCompose(backCompatResp -> {
            CompletableFuture<HttpResponse> processedResp = CompletableFuture.supplyAsync(() -> Exceptions.unchecked(() -> afterSuccessHook.afterSuccess(context, (HttpResponse<InputStream>)backCompatResp)).get());
            return processedResp.thenApply(HookAdapters::toBlobResponse);
        });
    }

    private static HttpResponse<Blob> toBlobResponse(HttpResponse<InputStream> response) {
        return new ResponseWithBody<InputStream, Blob>(response, Blob.from(response.body()));
    }

    private static CompletableFuture<HttpResponse<InputStream>> toStreamResponse(HttpResponse<Blob> response) {
        return response.body().toInputStream().thenApply(body -> new ResponseWithBody(response, (InputStream)body));
    }
}

