/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.models.components.UnifiedUploadRequestDto;
import com.stackone.stackone_client_java.models.operations.DocumentsDownloadFileRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsDownloadFileRequestBuilder;
import com.stackone.stackone_client_java.models.operations.DocumentsDownloadFileResponse;
import com.stackone.stackone_client_java.models.operations.DocumentsGetDriveRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsGetDriveRequestBuilder;
import com.stackone.stackone_client_java.models.operations.DocumentsGetDriveResponse;
import com.stackone.stackone_client_java.models.operations.DocumentsGetFileRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsGetFileRequestBuilder;
import com.stackone.stackone_client_java.models.operations.DocumentsGetFileResponse;
import com.stackone.stackone_client_java.models.operations.DocumentsGetFolderRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsGetFolderRequestBuilder;
import com.stackone.stackone_client_java.models.operations.DocumentsGetFolderResponse;
import com.stackone.stackone_client_java.models.operations.DocumentsListDrivesRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsListDrivesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.DocumentsListDrivesResponse;
import com.stackone.stackone_client_java.models.operations.DocumentsListFilesRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsListFilesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.DocumentsListFilesResponse;
import com.stackone.stackone_client_java.models.operations.DocumentsListFoldersRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsListFoldersRequestBuilder;
import com.stackone.stackone_client_java.models.operations.DocumentsListFoldersResponse;
import com.stackone.stackone_client_java.models.operations.DocumentsUploadFileRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsUploadFileRequestBuilder;
import com.stackone.stackone_client_java.models.operations.DocumentsUploadFileResponse;
import com.stackone.stackone_client_java.operations.DocumentsDownloadFile;
import com.stackone.stackone_client_java.operations.DocumentsGetDrive;
import com.stackone.stackone_client_java.operations.DocumentsGetFile;
import com.stackone.stackone_client_java.operations.DocumentsGetFolder;
import com.stackone.stackone_client_java.operations.DocumentsListDrives;
import com.stackone.stackone_client_java.operations.DocumentsListFiles;
import com.stackone.stackone_client_java.operations.DocumentsListFolders;
import com.stackone.stackone_client_java.operations.DocumentsUploadFile;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;


public class Documents {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncDocuments asyncSDK;

    Documents(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncDocuments(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncDocuments async() {
        return asyncSDK;
    }

    /**
     * Download File
     * 
     * @return The call builder
     */
    public DocumentsDownloadFileRequestBuilder downloadFile() {
        return new DocumentsDownloadFileRequestBuilder(sdkConfiguration);
    }

    /**
     * Download File
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsDownloadFileResponse downloadFile(DocumentsDownloadFileRequest request) {
        return downloadFile(request, Optional.empty());
    }

    /**
     * Download File
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsDownloadFileResponse downloadFile(DocumentsDownloadFileRequest request, Optional<Options> options) {
        RequestOperation<DocumentsDownloadFileRequest, DocumentsDownloadFileResponse> operation
              = new DocumentsDownloadFile.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Upload File
     * 
     * @return The call builder
     */
    public DocumentsUploadFileRequestBuilder uploadFile() {
        return new DocumentsUploadFileRequestBuilder(sdkConfiguration);
    }

    /**
     * Upload File
     * 
     * @param xAccountId The account identifier
     * @param unifiedUploadRequestDto 
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsUploadFileResponse uploadFile(String xAccountId, UnifiedUploadRequestDto unifiedUploadRequestDto) {
        return uploadFile(xAccountId, Optional.empty(), Optional.empty(),
            unifiedUploadRequestDto, Optional.empty());
    }

    /**
     * Upload File
     * 
     * @param xAccountId The account identifier
     * @param xStackoneApiSessionToken The session token
     * @param prefer Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     * @param unifiedUploadRequestDto 
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsUploadFileResponse uploadFile(
            String xAccountId, Optional<String> xStackoneApiSessionToken,
            Optional<String> prefer, UnifiedUploadRequestDto unifiedUploadRequestDto,
            Optional<Options> options) {
        DocumentsUploadFileRequest request =
            DocumentsUploadFileRequest
                .builder()
                .xAccountId(xAccountId)
                .xStackoneApiSessionToken(xStackoneApiSessionToken)
                .prefer(prefer)
                .unifiedUploadRequestDto(unifiedUploadRequestDto)
                .build();
        RequestOperation<DocumentsUploadFileRequest, DocumentsUploadFileResponse> operation
              = new DocumentsUploadFile.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Files
     * 
     * @return The call builder
     */
    public DocumentsListFilesRequestBuilder listFiles() {
        return new DocumentsListFilesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Files
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsListFilesResponse listFiles(DocumentsListFilesRequest request) {
        return listFiles(request, Optional.empty());
    }

    /**
     * List Files
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsListFilesResponse listFiles(DocumentsListFilesRequest request, Optional<Options> options) {
        RequestOperation<DocumentsListFilesRequest, DocumentsListFilesResponse> operation
              = new DocumentsListFiles.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get File
     * 
     * @return The call builder
     */
    public DocumentsGetFileRequestBuilder getFile() {
        return new DocumentsGetFileRequestBuilder(sdkConfiguration);
    }

    /**
     * Get File
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsGetFileResponse getFile(DocumentsGetFileRequest request) {
        return getFile(request, Optional.empty());
    }

    /**
     * Get File
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsGetFileResponse getFile(DocumentsGetFileRequest request, Optional<Options> options) {
        RequestOperation<DocumentsGetFileRequest, DocumentsGetFileResponse> operation
              = new DocumentsGetFile.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Folders
     * 
     * @return The call builder
     */
    public DocumentsListFoldersRequestBuilder listFolders() {
        return new DocumentsListFoldersRequestBuilder(sdkConfiguration);
    }

    /**
     * List Folders
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsListFoldersResponse listFolders(DocumentsListFoldersRequest request) {
        return listFolders(request, Optional.empty());
    }

    /**
     * List Folders
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsListFoldersResponse listFolders(DocumentsListFoldersRequest request, Optional<Options> options) {
        RequestOperation<DocumentsListFoldersRequest, DocumentsListFoldersResponse> operation
              = new DocumentsListFolders.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Folder
     * 
     * @return The call builder
     */
    public DocumentsGetFolderRequestBuilder getFolder() {
        return new DocumentsGetFolderRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Folder
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsGetFolderResponse getFolder(DocumentsGetFolderRequest request) {
        return getFolder(request, Optional.empty());
    }

    /**
     * Get Folder
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsGetFolderResponse getFolder(DocumentsGetFolderRequest request, Optional<Options> options) {
        RequestOperation<DocumentsGetFolderRequest, DocumentsGetFolderResponse> operation
              = new DocumentsGetFolder.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Drives
     * 
     * @return The call builder
     */
    public DocumentsListDrivesRequestBuilder listDrives() {
        return new DocumentsListDrivesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Drives
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsListDrivesResponse listDrives(DocumentsListDrivesRequest request) {
        return listDrives(request, Optional.empty());
    }

    /**
     * List Drives
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsListDrivesResponse listDrives(DocumentsListDrivesRequest request, Optional<Options> options) {
        RequestOperation<DocumentsListDrivesRequest, DocumentsListDrivesResponse> operation
              = new DocumentsListDrives.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Drive
     * 
     * @return The call builder
     */
    public DocumentsGetDriveRequestBuilder getDrive() {
        return new DocumentsGetDriveRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Drive
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsGetDriveResponse getDrive(DocumentsGetDriveRequest request) {
        return getDrive(request, Optional.empty());
    }

    /**
     * Get Drive
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public DocumentsGetDriveResponse getDrive(DocumentsGetDriveRequest request, Optional<Options> options) {
        RequestOperation<DocumentsGetDriveRequest, DocumentsGetDriveResponse> operation
              = new DocumentsGetDrive.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
