/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
public class HRISGroupValue {

    public static final HRISGroupValue WORKSPACE = new HRISGroupValue("workspace");
    public static final HRISGroupValue TEAM = new HRISGroupValue("team");
    public static final HRISGroupValue DEPARTMENT = new HRISGroupValue("department");
    public static final HRISGroupValue GROUP = new HRISGroupValue("group");
    public static final HRISGroupValue ORGANIZATION = new HRISGroupValue("organization");
    public static final HRISGroupValue UNMAPPED_VALUE = new HRISGroupValue("unmapped_value");
    public static final HRISGroupValue COST_CENTER = new HRISGroupValue("cost_center");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, HRISGroupValue> values = createValuesMap();
    private static final Map<String, HRISGroupValueEnum> enums = createEnumsMap();

    private final String value;

    private HRISGroupValue(String value) {
        this.value = value;
    }

    /**
     * Returns a HRISGroupValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as HRISGroupValue
     */ 
    @JsonCreator
    public static HRISGroupValue of(String value) {
        synchronized (HRISGroupValue.class) {
            return values.computeIfAbsent(value, v -> new HRISGroupValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<HRISGroupValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        HRISGroupValue other = (HRISGroupValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "HRISGroupValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static HRISGroupValue[] values() {
        synchronized (HRISGroupValue.class) {
            return values.values().toArray(new HRISGroupValue[] {});
        }
    }

    private static final Map<String, HRISGroupValue> createValuesMap() {
        Map<String, HRISGroupValue> map = new LinkedHashMap<>();
        map.put("workspace", WORKSPACE);
        map.put("team", TEAM);
        map.put("department", DEPARTMENT);
        map.put("group", GROUP);
        map.put("organization", ORGANIZATION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("cost_center", COST_CENTER);
        return map;
    }

    private static final Map<String, HRISGroupValueEnum> createEnumsMap() {
        Map<String, HRISGroupValueEnum> map = new HashMap<>();
        map.put("workspace", HRISGroupValueEnum.WORKSPACE);
        map.put("team", HRISGroupValueEnum.TEAM);
        map.put("department", HRISGroupValueEnum.DEPARTMENT);
        map.put("group", HRISGroupValueEnum.GROUP);
        map.put("organization", HRISGroupValueEnum.ORGANIZATION);
        map.put("unmapped_value", HRISGroupValueEnum.UNMAPPED_VALUE);
        map.put("cost_center", HRISGroupValueEnum.COST_CENTER);
        return map;
    }
    
    
    public enum HRISGroupValueEnum {

        WORKSPACE("workspace"),
        TEAM("team"),
        DEPARTMENT("department"),
        GROUP("group"),
        ORGANIZATION("organization"),
        UNMAPPED_VALUE("unmapped_value"),
        COST_CENTER("cost_center"),;

        private final String value;

        private HRISGroupValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

