/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
public class Internal {

    public static final Internal TRUE = new Internal("true");
    public static final Internal FALSE = new Internal("false");
    public static final Internal UNMAPPED_VALUE = new Internal("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, Internal> values = createValuesMap();
    private static final Map<String, InternalEnum> enums = createEnumsMap();

    private final String value;

    private Internal(String value) {
        this.value = value;
    }

    /**
     * Returns a Internal with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as Internal
     */ 
    @JsonCreator
    public static Internal of(String value) {
        synchronized (Internal.class) {
            return values.computeIfAbsent(value, v -> new Internal(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<InternalEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Internal other = (Internal) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "Internal [value=" + value + "]";
    }

    // return an array just like an enum
    public static Internal[] values() {
        synchronized (Internal.class) {
            return values.values().toArray(new Internal[] {});
        }
    }

    private static final Map<String, Internal> createValuesMap() {
        Map<String, Internal> map = new LinkedHashMap<>();
        map.put("true", TRUE);
        map.put("false", FALSE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, InternalEnum> createEnumsMap() {
        Map<String, InternalEnum> map = new HashMap<>();
        map.put("true", InternalEnum.TRUE);
        map.put("false", InternalEnum.FALSE);
        map.put("unmapped_value", InternalEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum InternalEnum {

        TRUE("true"),
        FALSE("false"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private InternalEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

