/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * Method
 * 
 * <p>The method of the request
 */
public class Method {

    public static final Method GET = new Method("get");
    public static final Method POST = new Method("post");
    public static final Method PUT = new Method("put");
    public static final Method DELETE = new Method("delete");
    public static final Method PATCH = new Method("patch");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, Method> values = createValuesMap();
    private static final Map<String, MethodEnum> enums = createEnumsMap();

    private final String value;

    private Method(String value) {
        this.value = value;
    }

    /**
     * Returns a Method with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as Method
     */ 
    @JsonCreator
    public static Method of(String value) {
        synchronized (Method.class) {
            return values.computeIfAbsent(value, v -> new Method(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<MethodEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Method other = (Method) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "Method [value=" + value + "]";
    }

    // return an array just like an enum
    public static Method[] values() {
        synchronized (Method.class) {
            return values.values().toArray(new Method[] {});
        }
    }

    private static final Map<String, Method> createValuesMap() {
        Map<String, Method> map = new LinkedHashMap<>();
        map.put("get", GET);
        map.put("post", POST);
        map.put("put", PUT);
        map.put("delete", DELETE);
        map.put("patch", PATCH);
        return map;
    }

    private static final Map<String, MethodEnum> createEnumsMap() {
        Map<String, MethodEnum> map = new HashMap<>();
        map.put("get", MethodEnum.GET);
        map.put("post", MethodEnum.POST);
        map.put("put", MethodEnum.PUT);
        map.put("delete", MethodEnum.DELETE);
        map.put("patch", MethodEnum.PATCH);
        return map;
    }
    
    
    public enum MethodEnum {

        GET("get"),
        POST("post"),
        PUT("put"),
        DELETE("delete"),
        PATCH("patch"),;

        private final String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

