/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.AccountingJournalCreateRequestDto;
import com.stackone.stackone_client_java.operations.AccountingCreateCompanyJournal;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.String;
import java.util.Optional;

public class AccountingCreateCompanyJournalRequestBuilder {

    private String xAccountId;
    private String id;
    private Optional<String> prefer = Optional.empty();
    private AccountingJournalCreateRequestDto accountingJournalCreateRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public AccountingCreateCompanyJournalRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AccountingCreateCompanyJournalRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AccountingCreateCompanyJournalRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }
                
    public AccountingCreateCompanyJournalRequestBuilder prefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.of(prefer);
        return this;
    }

    public AccountingCreateCompanyJournalRequestBuilder prefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AccountingCreateCompanyJournalRequestBuilder accountingJournalCreateRequestDto(AccountingJournalCreateRequestDto accountingJournalCreateRequestDto) {
        Utils.checkNotNull(accountingJournalCreateRequestDto, "accountingJournalCreateRequestDto");
        this.accountingJournalCreateRequestDto = accountingJournalCreateRequestDto;
        return this;
    }
                
    public AccountingCreateCompanyJournalRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AccountingCreateCompanyJournalRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private AccountingCreateCompanyJournalRequest buildRequest() {

        AccountingCreateCompanyJournalRequest request = new AccountingCreateCompanyJournalRequest(xAccountId,
            id,
            prefer,
            accountingJournalCreateRequestDto);

        return request;
    }

    public AccountingCreateCompanyJournalResponse call() {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        RequestOperation<AccountingCreateCompanyJournalRequest, AccountingCreateCompanyJournalResponse> operation
              = new AccountingCreateCompanyJournal.Sync(sdkConfiguration, options, _headers);
        AccountingCreateCompanyJournalRequest request = buildRequest();

        return operation.handleResponse(operation.doRequest(request));
    }
}
