/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MarketingCreateEmailTemplateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class MarketingCreateEmailTemplateRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private MarketingCreateEmailTemplateRequestDto marketingCreateEmailTemplateRequestDto;

    @JsonCreator
    public MarketingCreateEmailTemplateRequest(
            String xAccountId,
            Optional<String> prefer,
            MarketingCreateEmailTemplateRequestDto marketingCreateEmailTemplateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(marketingCreateEmailTemplateRequestDto, "marketingCreateEmailTemplateRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.marketingCreateEmailTemplateRequestDto = marketingCreateEmailTemplateRequestDto;
    }
    
    public MarketingCreateEmailTemplateRequest(
            String xAccountId,
            MarketingCreateEmailTemplateRequestDto marketingCreateEmailTemplateRequestDto) {
        this(xAccountId, Optional.empty(), marketingCreateEmailTemplateRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public MarketingCreateEmailTemplateRequestDto marketingCreateEmailTemplateRequestDto() {
        return marketingCreateEmailTemplateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public MarketingCreateEmailTemplateRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public MarketingCreateEmailTemplateRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public MarketingCreateEmailTemplateRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public MarketingCreateEmailTemplateRequest withMarketingCreateEmailTemplateRequestDto(MarketingCreateEmailTemplateRequestDto marketingCreateEmailTemplateRequestDto) {
        Utils.checkNotNull(marketingCreateEmailTemplateRequestDto, "marketingCreateEmailTemplateRequestDto");
        this.marketingCreateEmailTemplateRequestDto = marketingCreateEmailTemplateRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MarketingCreateEmailTemplateRequest other = (MarketingCreateEmailTemplateRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.marketingCreateEmailTemplateRequestDto, other.marketingCreateEmailTemplateRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, prefer, marketingCreateEmailTemplateRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MarketingCreateEmailTemplateRequest.class,
                "xAccountId", xAccountId,
                "prefer", prefer,
                "marketingCreateEmailTemplateRequestDto", marketingCreateEmailTemplateRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> prefer = Optional.empty();

        private MarketingCreateEmailTemplateRequestDto marketingCreateEmailTemplateRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder marketingCreateEmailTemplateRequestDto(MarketingCreateEmailTemplateRequestDto marketingCreateEmailTemplateRequestDto) {
            Utils.checkNotNull(marketingCreateEmailTemplateRequestDto, "marketingCreateEmailTemplateRequestDto");
            this.marketingCreateEmailTemplateRequestDto = marketingCreateEmailTemplateRequestDto;
            return this;
        }

        public MarketingCreateEmailTemplateRequest build() {

            return new MarketingCreateEmailTemplateRequest(
                xAccountId, prefer, marketingCreateEmailTemplateRequestDto);
        }

    }
}
