/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.utils.LazySingletonValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class ActionBuildDto {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="connector_key")
    private Optional<String> connectorKey;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="force_refresh")
    private Optional<Boolean> forceRefresh;

    @JsonCreator
    public ActionBuildDto(@JsonProperty(value="connector_key") Optional<String> connectorKey, @JsonProperty(value="force_refresh") Optional<Boolean> forceRefresh) {
        Utils.checkNotNull(connectorKey, "connectorKey");
        Utils.checkNotNull(forceRefresh, "forceRefresh");
        this.connectorKey = connectorKey;
        this.forceRefresh = forceRefresh;
    }

    public ActionBuildDto() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> connectorKey() {
        return this.connectorKey;
    }

    @JsonIgnore
    public Optional<Boolean> forceRefresh() {
        return this.forceRefresh;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ActionBuildDto withConnectorKey(String connectorKey) {
        Utils.checkNotNull(connectorKey, "connectorKey");
        this.connectorKey = Optional.ofNullable(connectorKey);
        return this;
    }

    public ActionBuildDto withConnectorKey(Optional<String> connectorKey) {
        Utils.checkNotNull(connectorKey, "connectorKey");
        this.connectorKey = connectorKey;
        return this;
    }

    public ActionBuildDto withForceRefresh(boolean forceRefresh) {
        Utils.checkNotNull(forceRefresh, "forceRefresh");
        this.forceRefresh = Optional.ofNullable(forceRefresh);
        return this;
    }

    public ActionBuildDto withForceRefresh(Optional<Boolean> forceRefresh) {
        Utils.checkNotNull(forceRefresh, "forceRefresh");
        this.forceRefresh = forceRefresh;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionBuildDto other = (ActionBuildDto)o;
        return Utils.enhancedDeepEquals(this.connectorKey, other.connectorKey) && Utils.enhancedDeepEquals(this.forceRefresh, other.forceRefresh);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.connectorKey, this.forceRefresh);
    }

    public String toString() {
        return Utils.toString(ActionBuildDto.class, "connectorKey", this.connectorKey, "forceRefresh", this.forceRefresh);
    }

    public static final class Builder {
        private Optional<String> connectorKey = Optional.empty();
        private Optional<Boolean> forceRefresh;
        private static final LazySingletonValue<Optional<Boolean>> _SINGLETON_VALUE_ForceRefresh = new LazySingletonValue<Optional<Boolean>>("force_refresh", "false", new TypeReference<Optional<Boolean>>(){});

        private Builder() {
        }

        public Builder connectorKey(String connectorKey) {
            Utils.checkNotNull(connectorKey, "connectorKey");
            this.connectorKey = Optional.ofNullable(connectorKey);
            return this;
        }

        public Builder connectorKey(Optional<String> connectorKey) {
            Utils.checkNotNull(connectorKey, "connectorKey");
            this.connectorKey = connectorKey;
            return this;
        }

        public Builder forceRefresh(boolean forceRefresh) {
            Utils.checkNotNull(forceRefresh, "forceRefresh");
            this.forceRefresh = Optional.ofNullable(forceRefresh);
            return this;
        }

        public Builder forceRefresh(Optional<Boolean> forceRefresh) {
            Utils.checkNotNull(forceRefresh, "forceRefresh");
            this.forceRefresh = forceRefresh;
            return this;
        }

        public ActionBuildDto build() {
            if (this.forceRefresh == null) {
                this.forceRefresh = _SINGLETON_VALUE_ForceRefresh.value();
            }
            return new ActionBuildDto(this.connectorKey, this.forceRefresh);
        }
    }
}

