/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ContentBlockStatusValue {
    public static final ContentBlockStatusValue DRAFT = new ContentBlockStatusValue("draft");
    public static final ContentBlockStatusValue LIVE = new ContentBlockStatusValue("live");
    public static final ContentBlockStatusValue ARCHIVED = new ContentBlockStatusValue("archived");
    public static final ContentBlockStatusValue UNMAPPED_VALUE = new ContentBlockStatusValue("unmapped_value");
    private static final Map<String, ContentBlockStatusValue> values = ContentBlockStatusValue.createValuesMap();
    private static final Map<String, ContentBlockStatusValueEnum> enums = ContentBlockStatusValue.createEnumsMap();
    private final String value;

    private ContentBlockStatusValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static ContentBlockStatusValue of(String value) {
        Class<ContentBlockStatusValue> clazz = ContentBlockStatusValue.class;
        synchronized (ContentBlockStatusValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new ContentBlockStatusValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<ContentBlockStatusValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentBlockStatusValue other = (ContentBlockStatusValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "ContentBlockStatusValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentBlockStatusValue[] values() {
        Class<ContentBlockStatusValue> clazz = ContentBlockStatusValue.class;
        synchronized (ContentBlockStatusValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new ContentBlockStatusValue[0]);
        }
    }

    private static final Map<String, ContentBlockStatusValue> createValuesMap() {
        LinkedHashMap<String, ContentBlockStatusValue> map = new LinkedHashMap<String, ContentBlockStatusValue>();
        map.put("draft", DRAFT);
        map.put("live", LIVE);
        map.put("archived", ARCHIVED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ContentBlockStatusValueEnum> createEnumsMap() {
        HashMap<String, ContentBlockStatusValueEnum> map = new HashMap<String, ContentBlockStatusValueEnum>();
        map.put("draft", ContentBlockStatusValueEnum.DRAFT);
        map.put("live", ContentBlockStatusValueEnum.LIVE);
        map.put("archived", ContentBlockStatusValueEnum.ARCHIVED);
        map.put("unmapped_value", ContentBlockStatusValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum ContentBlockStatusValueEnum {
        DRAFT("draft"),
        LIVE("live"),
        ARCHIVED("archived"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private ContentBlockStatusValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

