/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CustomFieldDefinitionValue {
    public static final CustomFieldDefinitionValue DATE = new CustomFieldDefinitionValue("date");
    public static final CustomFieldDefinitionValue FLOAT = new CustomFieldDefinitionValue("float");
    public static final CustomFieldDefinitionValue INTEGER = new CustomFieldDefinitionValue("integer");
    public static final CustomFieldDefinitionValue LIST = new CustomFieldDefinitionValue("list");
    public static final CustomFieldDefinitionValue CHECKBOX = new CustomFieldDefinitionValue("checkbox");
    public static final CustomFieldDefinitionValue TEXT = new CustomFieldDefinitionValue("text");
    public static final CustomFieldDefinitionValue BOOLEAN = new CustomFieldDefinitionValue("boolean");
    public static final CustomFieldDefinitionValue SINGLE_SELECT = new CustomFieldDefinitionValue("single_select");
    public static final CustomFieldDefinitionValue MULTI_SELECT = new CustomFieldDefinitionValue("multi_select");
    public static final CustomFieldDefinitionValue URL = new CustomFieldDefinitionValue("url");
    public static final CustomFieldDefinitionValue OTHER = new CustomFieldDefinitionValue("other");
    public static final CustomFieldDefinitionValue UNMAPPED_VALUE = new CustomFieldDefinitionValue("unmapped_value");
    private static final Map<String, CustomFieldDefinitionValue> values = CustomFieldDefinitionValue.createValuesMap();
    private static final Map<String, CustomFieldDefinitionValueEnum> enums = CustomFieldDefinitionValue.createEnumsMap();
    private final String value;

    private CustomFieldDefinitionValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static CustomFieldDefinitionValue of(String value) {
        Class<CustomFieldDefinitionValue> clazz = CustomFieldDefinitionValue.class;
        synchronized (CustomFieldDefinitionValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new CustomFieldDefinitionValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<CustomFieldDefinitionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomFieldDefinitionValue other = (CustomFieldDefinitionValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "CustomFieldDefinitionValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CustomFieldDefinitionValue[] values() {
        Class<CustomFieldDefinitionValue> clazz = CustomFieldDefinitionValue.class;
        synchronized (CustomFieldDefinitionValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new CustomFieldDefinitionValue[0]);
        }
    }

    private static final Map<String, CustomFieldDefinitionValue> createValuesMap() {
        LinkedHashMap<String, CustomFieldDefinitionValue> map = new LinkedHashMap<String, CustomFieldDefinitionValue>();
        map.put("date", DATE);
        map.put("float", FLOAT);
        map.put("integer", INTEGER);
        map.put("list", LIST);
        map.put("checkbox", CHECKBOX);
        map.put("text", TEXT);
        map.put("boolean", BOOLEAN);
        map.put("single_select", SINGLE_SELECT);
        map.put("multi_select", MULTI_SELECT);
        map.put("url", URL);
        map.put("other", OTHER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CustomFieldDefinitionValueEnum> createEnumsMap() {
        HashMap<String, CustomFieldDefinitionValueEnum> map = new HashMap<String, CustomFieldDefinitionValueEnum>();
        map.put("date", CustomFieldDefinitionValueEnum.DATE);
        map.put("float", CustomFieldDefinitionValueEnum.FLOAT);
        map.put("integer", CustomFieldDefinitionValueEnum.INTEGER);
        map.put("list", CustomFieldDefinitionValueEnum.LIST);
        map.put("checkbox", CustomFieldDefinitionValueEnum.CHECKBOX);
        map.put("text", CustomFieldDefinitionValueEnum.TEXT);
        map.put("boolean", CustomFieldDefinitionValueEnum.BOOLEAN);
        map.put("single_select", CustomFieldDefinitionValueEnum.SINGLE_SELECT);
        map.put("multi_select", CustomFieldDefinitionValueEnum.MULTI_SELECT);
        map.put("url", CustomFieldDefinitionValueEnum.URL);
        map.put("other", CustomFieldDefinitionValueEnum.OTHER);
        map.put("unmapped_value", CustomFieldDefinitionValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum CustomFieldDefinitionValueEnum {
        DATE("date"),
        FLOAT("float"),
        INTEGER("integer"),
        LIST("list"),
        CHECKBOX("checkbox"),
        TEXT("text"),
        BOOLEAN("boolean"),
        SINGLE_SELECT("single_select"),
        MULTI_SELECT("multi_select"),
        URL("url"),
        OTHER("other"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private CustomFieldDefinitionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

