/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HRISCostCenterValue {
    public static final HRISCostCenterValue WORKSPACE = new HRISCostCenterValue("workspace");
    public static final HRISCostCenterValue TEAM = new HRISCostCenterValue("team");
    public static final HRISCostCenterValue DEPARTMENT = new HRISCostCenterValue("department");
    public static final HRISCostCenterValue GROUP = new HRISCostCenterValue("group");
    public static final HRISCostCenterValue ORGANIZATION = new HRISCostCenterValue("organization");
    public static final HRISCostCenterValue UNMAPPED_VALUE = new HRISCostCenterValue("unmapped_value");
    public static final HRISCostCenterValue COST_CENTER = new HRISCostCenterValue("cost_center");
    private static final Map<String, HRISCostCenterValue> values = HRISCostCenterValue.createValuesMap();
    private static final Map<String, HRISCostCenterValueEnum> enums = HRISCostCenterValue.createEnumsMap();
    private final String value;

    private HRISCostCenterValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static HRISCostCenterValue of(String value) {
        Class<HRISCostCenterValue> clazz = HRISCostCenterValue.class;
        synchronized (HRISCostCenterValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new HRISCostCenterValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<HRISCostCenterValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HRISCostCenterValue other = (HRISCostCenterValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "HRISCostCenterValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRISCostCenterValue[] values() {
        Class<HRISCostCenterValue> clazz = HRISCostCenterValue.class;
        synchronized (HRISCostCenterValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new HRISCostCenterValue[0]);
        }
    }

    private static final Map<String, HRISCostCenterValue> createValuesMap() {
        LinkedHashMap<String, HRISCostCenterValue> map = new LinkedHashMap<String, HRISCostCenterValue>();
        map.put("workspace", WORKSPACE);
        map.put("team", TEAM);
        map.put("department", DEPARTMENT);
        map.put("group", GROUP);
        map.put("organization", ORGANIZATION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("cost_center", COST_CENTER);
        return map;
    }

    private static final Map<String, HRISCostCenterValueEnum> createEnumsMap() {
        HashMap<String, HRISCostCenterValueEnum> map = new HashMap<String, HRISCostCenterValueEnum>();
        map.put("workspace", HRISCostCenterValueEnum.WORKSPACE);
        map.put("team", HRISCostCenterValueEnum.TEAM);
        map.put("department", HRISCostCenterValueEnum.DEPARTMENT);
        map.put("group", HRISCostCenterValueEnum.GROUP);
        map.put("organization", HRISCostCenterValueEnum.ORGANIZATION);
        map.put("unmapped_value", HRISCostCenterValueEnum.UNMAPPED_VALUE);
        map.put("cost_center", HRISCostCenterValueEnum.COST_CENTER);
        return map;
    }

    public static enum HRISCostCenterValueEnum {
        WORKSPACE("workspace"),
        TEAM("team"),
        DEPARTMENT("department"),
        GROUP("group"),
        ORGANIZATION("organization"),
        UNMAPPED_VALUE("unmapped_value"),
        COST_CENTER("cost_center");

        private final String value;

        private HRISCostCenterValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

