/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HRISGroupValue {
    public static final HRISGroupValue WORKSPACE = new HRISGroupValue("workspace");
    public static final HRISGroupValue TEAM = new HRISGroupValue("team");
    public static final HRISGroupValue DEPARTMENT = new HRISGroupValue("department");
    public static final HRISGroupValue GROUP = new HRISGroupValue("group");
    public static final HRISGroupValue ORGANIZATION = new HRISGroupValue("organization");
    public static final HRISGroupValue UNMAPPED_VALUE = new HRISGroupValue("unmapped_value");
    public static final HRISGroupValue COST_CENTER = new HRISGroupValue("cost_center");
    private static final Map<String, HRISGroupValue> values = HRISGroupValue.createValuesMap();
    private static final Map<String, HRISGroupValueEnum> enums = HRISGroupValue.createEnumsMap();
    private final String value;

    private HRISGroupValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static HRISGroupValue of(String value) {
        Class<HRISGroupValue> clazz = HRISGroupValue.class;
        synchronized (HRISGroupValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new HRISGroupValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<HRISGroupValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HRISGroupValue other = (HRISGroupValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "HRISGroupValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRISGroupValue[] values() {
        Class<HRISGroupValue> clazz = HRISGroupValue.class;
        synchronized (HRISGroupValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new HRISGroupValue[0]);
        }
    }

    private static final Map<String, HRISGroupValue> createValuesMap() {
        LinkedHashMap<String, HRISGroupValue> map = new LinkedHashMap<String, HRISGroupValue>();
        map.put("workspace", WORKSPACE);
        map.put("team", TEAM);
        map.put("department", DEPARTMENT);
        map.put("group", GROUP);
        map.put("organization", ORGANIZATION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("cost_center", COST_CENTER);
        return map;
    }

    private static final Map<String, HRISGroupValueEnum> createEnumsMap() {
        HashMap<String, HRISGroupValueEnum> map = new HashMap<String, HRISGroupValueEnum>();
        map.put("workspace", HRISGroupValueEnum.WORKSPACE);
        map.put("team", HRISGroupValueEnum.TEAM);
        map.put("department", HRISGroupValueEnum.DEPARTMENT);
        map.put("group", HRISGroupValueEnum.GROUP);
        map.put("organization", HRISGroupValueEnum.ORGANIZATION);
        map.put("unmapped_value", HRISGroupValueEnum.UNMAPPED_VALUE);
        map.put("cost_center", HRISGroupValueEnum.COST_CENTER);
        return map;
    }

    public static enum HRISGroupValueEnum {
        WORKSPACE("workspace"),
        TEAM("team"),
        DEPARTMENT("department"),
        GROUP("group"),
        ORGANIZATION("organization"),
        UNMAPPED_VALUE("unmapped_value"),
        COST_CENTER("cost_center");

        private final String value;

        private HRISGroupValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

