/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HrisShiftResultDataValue {
    public static final HrisShiftResultDataValue PENDING = new HrisShiftResultDataValue("pending");
    public static final HrisShiftResultDataValue APPROVED = new HrisShiftResultDataValue("approved");
    public static final HrisShiftResultDataValue REJECTED = new HrisShiftResultDataValue("rejected");
    public static final HrisShiftResultDataValue UNMAPPED_VALUE = new HrisShiftResultDataValue("unmapped_value");
    private static final Map<String, HrisShiftResultDataValue> values = HrisShiftResultDataValue.createValuesMap();
    private static final Map<String, HrisShiftResultDataValueEnum> enums = HrisShiftResultDataValue.createEnumsMap();
    private final String value;

    private HrisShiftResultDataValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static HrisShiftResultDataValue of(String value) {
        Class<HrisShiftResultDataValue> clazz = HrisShiftResultDataValue.class;
        synchronized (HrisShiftResultDataValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new HrisShiftResultDataValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<HrisShiftResultDataValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HrisShiftResultDataValue other = (HrisShiftResultDataValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "HrisShiftResultDataValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HrisShiftResultDataValue[] values() {
        Class<HrisShiftResultDataValue> clazz = HrisShiftResultDataValue.class;
        synchronized (HrisShiftResultDataValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new HrisShiftResultDataValue[0]);
        }
    }

    private static final Map<String, HrisShiftResultDataValue> createValuesMap() {
        LinkedHashMap<String, HrisShiftResultDataValue> map = new LinkedHashMap<String, HrisShiftResultDataValue>();
        map.put("pending", PENDING);
        map.put("approved", APPROVED);
        map.put("rejected", REJECTED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HrisShiftResultDataValueEnum> createEnumsMap() {
        HashMap<String, HrisShiftResultDataValueEnum> map = new HashMap<String, HrisShiftResultDataValueEnum>();
        map.put("pending", HrisShiftResultDataValueEnum.PENDING);
        map.put("approved", HrisShiftResultDataValueEnum.APPROVED);
        map.put("rejected", HrisShiftResultDataValueEnum.REJECTED);
        map.put("unmapped_value", HrisShiftResultDataValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum HrisShiftResultDataValueEnum {
        PENDING("pending"),
        APPROVED("approved"),
        REJECTED("rejected"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private HrisShiftResultDataValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

