/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LinkedAccountType {
    public static final LinkedAccountType PRODUCTION = new LinkedAccountType("production");
    public static final LinkedAccountType TEST = new LinkedAccountType("test");
    public static final LinkedAccountType UNMAPPED_VALUE = new LinkedAccountType("unmapped_value");
    private static final Map<String, LinkedAccountType> values = LinkedAccountType.createValuesMap();
    private static final Map<String, LinkedAccountTypeEnum> enums = LinkedAccountType.createEnumsMap();
    private final String value;

    private LinkedAccountType(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static LinkedAccountType of(String value) {
        Class<LinkedAccountType> clazz = LinkedAccountType.class;
        synchronized (LinkedAccountType.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new LinkedAccountType((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<LinkedAccountTypeEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkedAccountType other = (LinkedAccountType)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "LinkedAccountType [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedAccountType[] values() {
        Class<LinkedAccountType> clazz = LinkedAccountType.class;
        synchronized (LinkedAccountType.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new LinkedAccountType[0]);
        }
    }

    private static final Map<String, LinkedAccountType> createValuesMap() {
        LinkedHashMap<String, LinkedAccountType> map = new LinkedHashMap<String, LinkedAccountType>();
        map.put("production", PRODUCTION);
        map.put("test", TEST);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, LinkedAccountTypeEnum> createEnumsMap() {
        HashMap<String, LinkedAccountTypeEnum> map = new HashMap<String, LinkedAccountTypeEnum>();
        map.put("production", LinkedAccountTypeEnum.PRODUCTION);
        map.put("test", LinkedAccountTypeEnum.TEST);
        map.put("unmapped_value", LinkedAccountTypeEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum LinkedAccountTypeEnum {
        PRODUCTION("production"),
        TEST("test"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private LinkedAccountTypeEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

