/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TicketingUserResultValue {
    public static final TicketingUserResultValue AGENT = new TicketingUserResultValue("agent");
    public static final TicketingUserResultValue CONTACT = new TicketingUserResultValue("contact");
    public static final TicketingUserResultValue BOT = new TicketingUserResultValue("bot");
    public static final TicketingUserResultValue UNMAPPED_VALUE = new TicketingUserResultValue("unmapped_value");
    private static final Map<String, TicketingUserResultValue> values = TicketingUserResultValue.createValuesMap();
    private static final Map<String, TicketingUserResultValueEnum> enums = TicketingUserResultValue.createEnumsMap();
    private final String value;

    private TicketingUserResultValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static TicketingUserResultValue of(String value) {
        Class<TicketingUserResultValue> clazz = TicketingUserResultValue.class;
        synchronized (TicketingUserResultValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TicketingUserResultValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<TicketingUserResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TicketingUserResultValue other = (TicketingUserResultValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TicketingUserResultValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TicketingUserResultValue[] values() {
        Class<TicketingUserResultValue> clazz = TicketingUserResultValue.class;
        synchronized (TicketingUserResultValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TicketingUserResultValue[0]);
        }
    }

    private static final Map<String, TicketingUserResultValue> createValuesMap() {
        LinkedHashMap<String, TicketingUserResultValue> map = new LinkedHashMap<String, TicketingUserResultValue>();
        map.put("agent", AGENT);
        map.put("contact", CONTACT);
        map.put("bot", BOT);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TicketingUserResultValueEnum> createEnumsMap() {
        HashMap<String, TicketingUserResultValueEnum> map = new HashMap<String, TicketingUserResultValueEnum>();
        map.put("agent", TicketingUserResultValueEnum.AGENT);
        map.put("contact", TicketingUserResultValueEnum.CONTACT);
        map.put("bot", TicketingUserResultValueEnum.BOT);
        map.put("unmapped_value", TicketingUserResultValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TicketingUserResultValueEnum {
        AGENT("agent"),
        CONTACT("contact"),
        BOT("bot"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TicketingUserResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

