/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateJobRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsCreateJobRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AtsCreateJobRequestDto atsCreateJobRequestDto;

    @JsonCreator
    public AtsCreateJobRequest(String xAccountId, Optional<String> prefer, AtsCreateJobRequestDto atsCreateJobRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsCreateJobRequestDto, "atsCreateJobRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.atsCreateJobRequestDto = atsCreateJobRequestDto;
    }

    public AtsCreateJobRequest(String xAccountId, AtsCreateJobRequestDto atsCreateJobRequestDto) {
        this(xAccountId, Optional.empty(), atsCreateJobRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public AtsCreateJobRequestDto atsCreateJobRequestDto() {
        return this.atsCreateJobRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsCreateJobRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsCreateJobRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public AtsCreateJobRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsCreateJobRequest withAtsCreateJobRequestDto(AtsCreateJobRequestDto atsCreateJobRequestDto) {
        Utils.checkNotNull(atsCreateJobRequestDto, "atsCreateJobRequestDto");
        this.atsCreateJobRequestDto = atsCreateJobRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsCreateJobRequest other = (AtsCreateJobRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.atsCreateJobRequestDto, other.atsCreateJobRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.atsCreateJobRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsCreateJobRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "atsCreateJobRequestDto", this.atsCreateJobRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private AtsCreateJobRequestDto atsCreateJobRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder atsCreateJobRequestDto(AtsCreateJobRequestDto atsCreateJobRequestDto) {
            Utils.checkNotNull(atsCreateJobRequestDto, "atsCreateJobRequestDto");
            this.atsCreateJobRequestDto = atsCreateJobRequestDto;
            return this;
        }

        public AtsCreateJobRequest build() {
            return new AtsCreateJobRequest(this.xAccountId, this.prefer, this.atsCreateJobRequestDto);
        }
    }
}

