/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.CategoriesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LmsListCategoriesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends CategoriesPaginated> categoriesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public LmsListCategoriesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends CategoriesPaginated> categoriesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(categoriesPaginated, "categoriesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.categoriesPaginated = categoriesPaginated;
        this.headers = headers;
    }

    public LmsListCategoriesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<CategoriesPaginated> categoriesPaginated() {
        return this.categoriesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LmsListCategoriesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public LmsListCategoriesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public LmsListCategoriesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public LmsListCategoriesResponse withCategoriesPaginated(CategoriesPaginated categoriesPaginated) {
        Utils.checkNotNull(categoriesPaginated, "categoriesPaginated");
        this.categoriesPaginated = Optional.ofNullable(categoriesPaginated);
        return this;
    }

    public LmsListCategoriesResponse withCategoriesPaginated(Optional<? extends CategoriesPaginated> categoriesPaginated) {
        Utils.checkNotNull(categoriesPaginated, "categoriesPaginated");
        this.categoriesPaginated = categoriesPaginated;
        return this;
    }

    public LmsListCategoriesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LmsListCategoriesResponse other = (LmsListCategoriesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.categoriesPaginated, other.categoriesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.categoriesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(LmsListCategoriesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "categoriesPaginated", this.categoriesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends CategoriesPaginated> categoriesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder categoriesPaginated(CategoriesPaginated categoriesPaginated) {
            Utils.checkNotNull(categoriesPaginated, "categoriesPaginated");
            this.categoriesPaginated = Optional.ofNullable(categoriesPaginated);
            return this;
        }

        public Builder categoriesPaginated(Optional<? extends CategoriesPaginated> categoriesPaginated) {
            Utils.checkNotNull(categoriesPaginated, "categoriesPaginated");
            this.categoriesPaginated = categoriesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public LmsListCategoriesResponse build() {
            return new LmsListCategoriesResponse(this.contentType, this.statusCode, this.rawResponse, this.categoriesPaginated, this.headers);
        }
    }
}

