/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MessagingMessageSendRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class MessagingSendMessageRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private MessagingMessageSendRequestDto messagingMessageSendRequestDto;

    @JsonCreator
    public MessagingSendMessageRequest(String xAccountId, Optional<String> prefer, MessagingMessageSendRequestDto messagingMessageSendRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(messagingMessageSendRequestDto, "messagingMessageSendRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.messagingMessageSendRequestDto = messagingMessageSendRequestDto;
    }

    public MessagingSendMessageRequest(String xAccountId, MessagingMessageSendRequestDto messagingMessageSendRequestDto) {
        this(xAccountId, Optional.empty(), messagingMessageSendRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public MessagingMessageSendRequestDto messagingMessageSendRequestDto() {
        return this.messagingMessageSendRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MessagingSendMessageRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public MessagingSendMessageRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public MessagingSendMessageRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public MessagingSendMessageRequest withMessagingMessageSendRequestDto(MessagingMessageSendRequestDto messagingMessageSendRequestDto) {
        Utils.checkNotNull(messagingMessageSendRequestDto, "messagingMessageSendRequestDto");
        this.messagingMessageSendRequestDto = messagingMessageSendRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingSendMessageRequest other = (MessagingSendMessageRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.messagingMessageSendRequestDto, other.messagingMessageSendRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.messagingMessageSendRequestDto);
    }

    public String toString() {
        return Utils.toString(MessagingSendMessageRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "messagingMessageSendRequestDto", this.messagingMessageSendRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private MessagingMessageSendRequestDto messagingMessageSendRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder messagingMessageSendRequestDto(MessagingMessageSendRequestDto messagingMessageSendRequestDto) {
            Utils.checkNotNull(messagingMessageSendRequestDto, "messagingMessageSendRequestDto");
            this.messagingMessageSendRequestDto = messagingMessageSendRequestDto;
            return this;
        }

        public MessagingSendMessageRequest build() {
            return new MessagingSendMessageRequest(this.xAccountId, this.prefer, this.messagingMessageSendRequestDto);
        }
    }
}

