/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
@JsonDeserialize(using = WorkEligibilityValue._Deserializer.class)
@JsonSerialize(using = WorkEligibilityValue._Serializer.class)
public class WorkEligibilityValue {

    public static final WorkEligibilityValue VISA = new WorkEligibilityValue("visa");
    public static final WorkEligibilityValue PASSPORT = new WorkEligibilityValue("passport");
    public static final WorkEligibilityValue DRIVER_LICENSE = new WorkEligibilityValue("driver_license");
    public static final WorkEligibilityValue BIRTH_CERTIFICATE = new WorkEligibilityValue("birth_certificate");
    public static final WorkEligibilityValue OTHER = new WorkEligibilityValue("other");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, WorkEligibilityValue> values = createValuesMap();
    private static final Map<String, WorkEligibilityValueEnum> enums = createEnumsMap();

    private final String value;

    private WorkEligibilityValue(String value) {
        this.value = value;
    }

    /**
     * Returns a WorkEligibilityValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as WorkEligibilityValue
     */ 
    public static WorkEligibilityValue of(String value) {
        synchronized (WorkEligibilityValue.class) {
            return values.computeIfAbsent(value, v -> new WorkEligibilityValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<WorkEligibilityValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        WorkEligibilityValue other = (WorkEligibilityValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "WorkEligibilityValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static WorkEligibilityValue[] values() {
        synchronized (WorkEligibilityValue.class) {
            return values.values().toArray(new WorkEligibilityValue[] {});
        }
    }

    private static final Map<String, WorkEligibilityValue> createValuesMap() {
        Map<String, WorkEligibilityValue> map = new LinkedHashMap<>();
        map.put("visa", VISA);
        map.put("passport", PASSPORT);
        map.put("driver_license", DRIVER_LICENSE);
        map.put("birth_certificate", BIRTH_CERTIFICATE);
        map.put("other", OTHER);
        return map;
    }

    private static final Map<String, WorkEligibilityValueEnum> createEnumsMap() {
        Map<String, WorkEligibilityValueEnum> map = new HashMap<>();
        map.put("visa", WorkEligibilityValueEnum.VISA);
        map.put("passport", WorkEligibilityValueEnum.PASSPORT);
        map.put("driver_license", WorkEligibilityValueEnum.DRIVER_LICENSE);
        map.put("birth_certificate", WorkEligibilityValueEnum.BIRTH_CERTIFICATE);
        map.put("other", WorkEligibilityValueEnum.OTHER);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<WorkEligibilityValue> {

        protected _Serializer() {
            super(WorkEligibilityValue.class);
        }

        @Override
        public void serialize(WorkEligibilityValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<WorkEligibilityValue> {

        protected _Deserializer() {
            super(WorkEligibilityValue.class);
        }

        @Override
        public WorkEligibilityValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return WorkEligibilityValue.of(v);
        }
    }
    
    public enum WorkEligibilityValueEnum {

        VISA("visa"),
        PASSPORT("passport"),
        DRIVER_LICENSE("driver_license"),
        BIRTH_CERTIFICATE("birth_certificate"),
        OTHER("other"),;

        private final String value;

        private WorkEligibilityValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
