/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.BatchResultApiModel;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LmsBatchUpsertCourseResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends BatchResultApiModel> batchResultApiModel;
    private Map<String, List<String>> headers;

    @JsonCreator
    public LmsBatchUpsertCourseResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends BatchResultApiModel> batchResultApiModel, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(batchResultApiModel, "batchResultApiModel");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.batchResultApiModel = batchResultApiModel;
        this.headers = headers;
    }

    public LmsBatchUpsertCourseResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<BatchResultApiModel> batchResultApiModel() {
        return this.batchResultApiModel;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public LmsBatchUpsertCourseResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public LmsBatchUpsertCourseResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public LmsBatchUpsertCourseResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public LmsBatchUpsertCourseResponse withBatchResultApiModel(BatchResultApiModel batchResultApiModel) {
        Utils.checkNotNull(batchResultApiModel, "batchResultApiModel");
        this.batchResultApiModel = Optional.ofNullable(batchResultApiModel);
        return this;
    }

    public LmsBatchUpsertCourseResponse withBatchResultApiModel(Optional<? extends BatchResultApiModel> batchResultApiModel) {
        Utils.checkNotNull(batchResultApiModel, "batchResultApiModel");
        this.batchResultApiModel = batchResultApiModel;
        return this;
    }

    public LmsBatchUpsertCourseResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LmsBatchUpsertCourseResponse other = (LmsBatchUpsertCourseResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.batchResultApiModel, other.batchResultApiModel) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.batchResultApiModel, this.headers);
    }

    public String toString() {
        return Utils.toString(LmsBatchUpsertCourseResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "batchResultApiModel", this.batchResultApiModel, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends BatchResultApiModel> batchResultApiModel = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder batchResultApiModel(BatchResultApiModel batchResultApiModel) {
            Utils.checkNotNull(batchResultApiModel, "batchResultApiModel");
            this.batchResultApiModel = Optional.ofNullable(batchResultApiModel);
            return this;
        }

        public Builder batchResultApiModel(Optional<? extends BatchResultApiModel> batchResultApiModel) {
            Utils.checkNotNull(batchResultApiModel, "batchResultApiModel");
            this.batchResultApiModel = batchResultApiModel;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public LmsBatchUpsertCourseResponse build() {
            return new LmsBatchUpsertCourseResponse(this.contentType, this.statusCode, this.rawResponse, this.batchResultApiModel, this.headers);
        }
    }
}

