/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class CreateContentApiModel {

    /**
     * The external ID associated with this content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("external_reference")
    private JsonNullable<String> externalReference;

    /**
     * The title of the content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("title")
    private JsonNullable<String> title;

    /**
     * The description of the content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    /**
     * The external URL of the content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content_url")
    private JsonNullable<String> contentUrl;

    /**
     * The mobile friendly URL of the content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("mobile_launch_content_url")
    private JsonNullable<String> mobileLaunchContentUrl;

    /**
     * The order of the individual content within a content grouping. This is not applicable for pushing individual content.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("order")
    private JsonNullable<Double> order;

    @JsonCreator
    public CreateContentApiModel(
            @JsonProperty("external_reference") JsonNullable<String> externalReference,
            @JsonProperty("title") JsonNullable<String> title,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("content_url") JsonNullable<String> contentUrl,
            @JsonProperty("mobile_launch_content_url") JsonNullable<String> mobileLaunchContentUrl,
            @JsonProperty("order") JsonNullable<Double> order) {
        Utils.checkNotNull(externalReference, "externalReference");
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(contentUrl, "contentUrl");
        Utils.checkNotNull(mobileLaunchContentUrl, "mobileLaunchContentUrl");
        Utils.checkNotNull(order, "order");
        this.externalReference = externalReference;
        this.title = title;
        this.description = description;
        this.contentUrl = contentUrl;
        this.mobileLaunchContentUrl = mobileLaunchContentUrl;
        this.order = order;
    }
    
    public CreateContentApiModel() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The external ID associated with this content
     */
    @JsonIgnore
    public JsonNullable<String> externalReference() {
        return externalReference;
    }

    /**
     * The title of the content
     */
    @JsonIgnore
    public JsonNullable<String> title() {
        return title;
    }

    /**
     * The description of the content
     */
    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    /**
     * The external URL of the content
     */
    @JsonIgnore
    public JsonNullable<String> contentUrl() {
        return contentUrl;
    }

    /**
     * The mobile friendly URL of the content
     */
    @JsonIgnore
    public JsonNullable<String> mobileLaunchContentUrl() {
        return mobileLaunchContentUrl;
    }

    /**
     * The order of the individual content within a content grouping. This is not applicable for pushing individual content.
     */
    @JsonIgnore
    public JsonNullable<Double> order() {
        return order;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The external ID associated with this content
     */
    public CreateContentApiModel withExternalReference(String externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = JsonNullable.of(externalReference);
        return this;
    }

    /**
     * The external ID associated with this content
     */
    public CreateContentApiModel withExternalReference(JsonNullable<String> externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = externalReference;
        return this;
    }

    /**
     * The title of the content
     */
    public CreateContentApiModel withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = JsonNullable.of(title);
        return this;
    }

    /**
     * The title of the content
     */
    public CreateContentApiModel withTitle(JsonNullable<String> title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    /**
     * The description of the content
     */
    public CreateContentApiModel withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    /**
     * The description of the content
     */
    public CreateContentApiModel withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * The external URL of the content
     */
    public CreateContentApiModel withContentUrl(String contentUrl) {
        Utils.checkNotNull(contentUrl, "contentUrl");
        this.contentUrl = JsonNullable.of(contentUrl);
        return this;
    }

    /**
     * The external URL of the content
     */
    public CreateContentApiModel withContentUrl(JsonNullable<String> contentUrl) {
        Utils.checkNotNull(contentUrl, "contentUrl");
        this.contentUrl = contentUrl;
        return this;
    }

    /**
     * The mobile friendly URL of the content
     */
    public CreateContentApiModel withMobileLaunchContentUrl(String mobileLaunchContentUrl) {
        Utils.checkNotNull(mobileLaunchContentUrl, "mobileLaunchContentUrl");
        this.mobileLaunchContentUrl = JsonNullable.of(mobileLaunchContentUrl);
        return this;
    }

    /**
     * The mobile friendly URL of the content
     */
    public CreateContentApiModel withMobileLaunchContentUrl(JsonNullable<String> mobileLaunchContentUrl) {
        Utils.checkNotNull(mobileLaunchContentUrl, "mobileLaunchContentUrl");
        this.mobileLaunchContentUrl = mobileLaunchContentUrl;
        return this;
    }

    /**
     * The order of the individual content within a content grouping. This is not applicable for pushing individual content.
     */
    public CreateContentApiModel withOrder(double order) {
        Utils.checkNotNull(order, "order");
        this.order = JsonNullable.of(order);
        return this;
    }

    /**
     * The order of the individual content within a content grouping. This is not applicable for pushing individual content.
     */
    public CreateContentApiModel withOrder(JsonNullable<Double> order) {
        Utils.checkNotNull(order, "order");
        this.order = order;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateContentApiModel other = (CreateContentApiModel) o;
        return 
            Objects.deepEquals(this.externalReference, other.externalReference) &&
            Objects.deepEquals(this.title, other.title) &&
            Objects.deepEquals(this.description, other.description) &&
            Objects.deepEquals(this.contentUrl, other.contentUrl) &&
            Objects.deepEquals(this.mobileLaunchContentUrl, other.mobileLaunchContentUrl) &&
            Objects.deepEquals(this.order, other.order);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            externalReference,
            title,
            description,
            contentUrl,
            mobileLaunchContentUrl,
            order);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateContentApiModel.class,
                "externalReference", externalReference,
                "title", title,
                "description", description,
                "contentUrl", contentUrl,
                "mobileLaunchContentUrl", mobileLaunchContentUrl,
                "order", order);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> externalReference = JsonNullable.undefined();
 
        private JsonNullable<String> title = JsonNullable.undefined();
 
        private JsonNullable<String> description = JsonNullable.undefined();
 
        private JsonNullable<String> contentUrl = JsonNullable.undefined();
 
        private JsonNullable<String> mobileLaunchContentUrl = JsonNullable.undefined();
 
        private JsonNullable<Double> order = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The external ID associated with this content
         */
        public Builder externalReference(String externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = JsonNullable.of(externalReference);
            return this;
        }

        /**
         * The external ID associated with this content
         */
        public Builder externalReference(JsonNullable<String> externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = externalReference;
            return this;
        }

        /**
         * The title of the content
         */
        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = JsonNullable.of(title);
            return this;
        }

        /**
         * The title of the content
         */
        public Builder title(JsonNullable<String> title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }

        /**
         * The description of the content
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        /**
         * The description of the content
         */
        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }

        /**
         * The external URL of the content
         */
        public Builder contentUrl(String contentUrl) {
            Utils.checkNotNull(contentUrl, "contentUrl");
            this.contentUrl = JsonNullable.of(contentUrl);
            return this;
        }

        /**
         * The external URL of the content
         */
        public Builder contentUrl(JsonNullable<String> contentUrl) {
            Utils.checkNotNull(contentUrl, "contentUrl");
            this.contentUrl = contentUrl;
            return this;
        }

        /**
         * The mobile friendly URL of the content
         */
        public Builder mobileLaunchContentUrl(String mobileLaunchContentUrl) {
            Utils.checkNotNull(mobileLaunchContentUrl, "mobileLaunchContentUrl");
            this.mobileLaunchContentUrl = JsonNullable.of(mobileLaunchContentUrl);
            return this;
        }

        /**
         * The mobile friendly URL of the content
         */
        public Builder mobileLaunchContentUrl(JsonNullable<String> mobileLaunchContentUrl) {
            Utils.checkNotNull(mobileLaunchContentUrl, "mobileLaunchContentUrl");
            this.mobileLaunchContentUrl = mobileLaunchContentUrl;
            return this;
        }

        /**
         * The order of the individual content within a content grouping. This is not applicable for pushing individual content.
         */
        public Builder order(double order) {
            Utils.checkNotNull(order, "order");
            this.order = JsonNullable.of(order);
            return this;
        }

        /**
         * The order of the individual content within a content grouping. This is not applicable for pushing individual content.
         */
        public Builder order(JsonNullable<Double> order) {
            Utils.checkNotNull(order, "order");
            this.order = order;
            return this;
        }
        
        public CreateContentApiModel build() {
            return new CreateContentApiModel(
                externalReference,
                title,
                description,
                contentUrl,
                mobileLaunchContentUrl,
                order);
        }
    }
}
