/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class RejectedReasonType {

    /**
     * The type of the rejected reason.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends RejectedReasonValue> value;

    /**
     * The source value of the rejected reason type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends RejectedReasonSourceValue> sourceValue;

    @JsonCreator
    public RejectedReasonType(
            @JsonProperty("value") JsonNullable<? extends RejectedReasonValue> value,
            @JsonProperty("source_value") JsonNullable<? extends RejectedReasonSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public RejectedReasonType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The type of the rejected reason.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<RejectedReasonValue> value() {
        return (JsonNullable<RejectedReasonValue>) value;
    }

    /**
     * The source value of the rejected reason type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<RejectedReasonSourceValue> sourceValue() {
        return (JsonNullable<RejectedReasonSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The type of the rejected reason.
     */
    public RejectedReasonType withValue(RejectedReasonValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The type of the rejected reason.
     */
    public RejectedReasonType withValue(JsonNullable<? extends RejectedReasonValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the rejected reason type.
     */
    public RejectedReasonType withSourceValue(RejectedReasonSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the rejected reason type.
     */
    public RejectedReasonType withSourceValue(JsonNullable<? extends RejectedReasonSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RejectedReasonType other = (RejectedReasonType) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(RejectedReasonType.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends RejectedReasonValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends RejectedReasonSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The type of the rejected reason.
         */
        public Builder value(RejectedReasonValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The type of the rejected reason.
         */
        public Builder value(JsonNullable<? extends RejectedReasonValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the rejected reason type.
         */
        public Builder sourceValue(RejectedReasonSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the rejected reason type.
         */
        public Builder sourceValue(JsonNullable<? extends RejectedReasonSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public RejectedReasonType build() {
            return new RejectedReasonType(
                value,
                sourceValue);
        }
    }
}
