/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Application {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * Unique identifier of the candidate
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("candidate_id")
    private JsonNullable<String> candidateId;

    /**
     * Provider's unique identifier of the candidate
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_candidate_id")
    private JsonNullable<String> remoteCandidateId;

    /**
     * Unique identifier of the job
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("job_id")
    private JsonNullable<String> jobId;

    /**
     * Provider's unique identifier of the job
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_job_id")
    private JsonNullable<String> remoteJobId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("interview_stage")
    private JsonNullable<? extends ApplicationInterviewStage> interviewStage;

    /**
     * Unique identifier of the interview stage
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("interview_stage_id")
    private JsonNullable<String> interviewStageId;

    /**
     * Provider's unique identifier of the interview stage
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_interview_stage_id")
    private JsonNullable<String> remoteInterviewStageId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("rejected_reasons")
    private JsonNullable<? extends List<RejectedReason>> rejectedReasons;

    /**
     * Unique identifiers of the rejection reasons
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("rejected_reason_ids")
    private JsonNullable<? extends List<String>> rejectedReasonIds;

    /**
     * Provider's unique identifiers of the rejection reasons
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_rejected_reason_ids")
    private JsonNullable<? extends List<String>> remoteRejectedReasonIds;

    /**
     * Date of rejection
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("rejected_at")
    private JsonNullable<OffsetDateTime> rejectedAt;

    /**
     * Unique identifier of the location
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("location_id")
    @Deprecated
    private JsonNullable<String> locationId;

    /**
     * Provider's unique identifier of the location
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_location_id")
    private JsonNullable<String> remoteLocationId;

    /**
     * Unique identifiers of the locations
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("location_ids")
    private JsonNullable<? extends List<String>> locationIds;

    /**
     * Remote's unique identifiers of the locations
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_location_ids")
    private JsonNullable<? extends List<String>> remoteLocationIds;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("application_status")
    private JsonNullable<? extends ApplicationStatus> applicationStatus;

    /**
     * Questionnaires associated with the application
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("questionnaires")
    private JsonNullable<? extends List<Questionnaire>> questionnaires;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("candidate")
    private JsonNullable<? extends ApplicationCandidate> candidate;

    /**
     * Use `documents` expand instead
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("attachments")
    @Deprecated
    private JsonNullable<? extends List<ApplicationAttachment>> attachments;

    /**
     * The documents attached to this application (eg. resume, cover letter etc.)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("documents")
    private JsonNullable<? extends List<AtsDocumentApiModel>> documents;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("result_links")
    private JsonNullable<? extends List<ResultLink>> resultLinks;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source")
    private JsonNullable<? extends Source> source;

    /**
     * Date of creation
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * Date of last update
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    /**
     * The application custom fields
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("custom_fields")
    private JsonNullable<? extends List<CustomFields>> customFields;

    @JsonCreator
    public Application(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("candidate_id") JsonNullable<String> candidateId,
            @JsonProperty("remote_candidate_id") JsonNullable<String> remoteCandidateId,
            @JsonProperty("job_id") JsonNullable<String> jobId,
            @JsonProperty("remote_job_id") JsonNullable<String> remoteJobId,
            @JsonProperty("interview_stage") JsonNullable<? extends ApplicationInterviewStage> interviewStage,
            @JsonProperty("interview_stage_id") JsonNullable<String> interviewStageId,
            @JsonProperty("remote_interview_stage_id") JsonNullable<String> remoteInterviewStageId,
            @JsonProperty("rejected_reasons") JsonNullable<? extends List<RejectedReason>> rejectedReasons,
            @JsonProperty("rejected_reason_ids") JsonNullable<? extends List<String>> rejectedReasonIds,
            @JsonProperty("remote_rejected_reason_ids") JsonNullable<? extends List<String>> remoteRejectedReasonIds,
            @JsonProperty("rejected_at") JsonNullable<OffsetDateTime> rejectedAt,
            @JsonProperty("location_id") JsonNullable<String> locationId,
            @JsonProperty("remote_location_id") JsonNullable<String> remoteLocationId,
            @JsonProperty("location_ids") JsonNullable<? extends List<String>> locationIds,
            @JsonProperty("remote_location_ids") JsonNullable<? extends List<String>> remoteLocationIds,
            @JsonProperty("application_status") JsonNullable<? extends ApplicationStatus> applicationStatus,
            @JsonProperty("questionnaires") JsonNullable<? extends List<Questionnaire>> questionnaires,
            @JsonProperty("candidate") JsonNullable<? extends ApplicationCandidate> candidate,
            @JsonProperty("attachments") JsonNullable<? extends List<ApplicationAttachment>> attachments,
            @JsonProperty("documents") JsonNullable<? extends List<AtsDocumentApiModel>> documents,
            @JsonProperty("result_links") JsonNullable<? extends List<ResultLink>> resultLinks,
            @JsonProperty("source") JsonNullable<? extends Source> source,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt,
            @JsonProperty("custom_fields") JsonNullable<? extends List<CustomFields>> customFields) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(candidateId, "candidateId");
        Utils.checkNotNull(remoteCandidateId, "remoteCandidateId");
        Utils.checkNotNull(jobId, "jobId");
        Utils.checkNotNull(remoteJobId, "remoteJobId");
        Utils.checkNotNull(interviewStage, "interviewStage");
        Utils.checkNotNull(interviewStageId, "interviewStageId");
        Utils.checkNotNull(remoteInterviewStageId, "remoteInterviewStageId");
        Utils.checkNotNull(rejectedReasons, "rejectedReasons");
        Utils.checkNotNull(rejectedReasonIds, "rejectedReasonIds");
        Utils.checkNotNull(remoteRejectedReasonIds, "remoteRejectedReasonIds");
        Utils.checkNotNull(rejectedAt, "rejectedAt");
        Utils.checkNotNull(locationId, "locationId");
        Utils.checkNotNull(remoteLocationId, "remoteLocationId");
        Utils.checkNotNull(locationIds, "locationIds");
        Utils.checkNotNull(remoteLocationIds, "remoteLocationIds");
        Utils.checkNotNull(applicationStatus, "applicationStatus");
        Utils.checkNotNull(questionnaires, "questionnaires");
        Utils.checkNotNull(candidate, "candidate");
        Utils.checkNotNull(attachments, "attachments");
        Utils.checkNotNull(documents, "documents");
        Utils.checkNotNull(resultLinks, "resultLinks");
        Utils.checkNotNull(source, "source");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(customFields, "customFields");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.candidateId = candidateId;
        this.remoteCandidateId = remoteCandidateId;
        this.jobId = jobId;
        this.remoteJobId = remoteJobId;
        this.interviewStage = interviewStage;
        this.interviewStageId = interviewStageId;
        this.remoteInterviewStageId = remoteInterviewStageId;
        this.rejectedReasons = rejectedReasons;
        this.rejectedReasonIds = rejectedReasonIds;
        this.remoteRejectedReasonIds = remoteRejectedReasonIds;
        this.rejectedAt = rejectedAt;
        this.locationId = locationId;
        this.remoteLocationId = remoteLocationId;
        this.locationIds = locationIds;
        this.remoteLocationIds = remoteLocationIds;
        this.applicationStatus = applicationStatus;
        this.questionnaires = questionnaires;
        this.candidate = candidate;
        this.attachments = attachments;
        this.documents = documents;
        this.resultLinks = resultLinks;
        this.source = source;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.customFields = customFields;
    }
    
    public Application() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * Unique identifier of the candidate
     */
    @JsonIgnore
    public JsonNullable<String> candidateId() {
        return candidateId;
    }

    /**
     * Provider's unique identifier of the candidate
     */
    @JsonIgnore
    public JsonNullable<String> remoteCandidateId() {
        return remoteCandidateId;
    }

    /**
     * Unique identifier of the job
     */
    @JsonIgnore
    public JsonNullable<String> jobId() {
        return jobId;
    }

    /**
     * Provider's unique identifier of the job
     */
    @JsonIgnore
    public JsonNullable<String> remoteJobId() {
        return remoteJobId;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ApplicationInterviewStage> interviewStage() {
        return (JsonNullable<ApplicationInterviewStage>) interviewStage;
    }

    /**
     * Unique identifier of the interview stage
     */
    @JsonIgnore
    public JsonNullable<String> interviewStageId() {
        return interviewStageId;
    }

    /**
     * Provider's unique identifier of the interview stage
     */
    @JsonIgnore
    public JsonNullable<String> remoteInterviewStageId() {
        return remoteInterviewStageId;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<RejectedReason>> rejectedReasons() {
        return (JsonNullable<List<RejectedReason>>) rejectedReasons;
    }

    /**
     * Unique identifiers of the rejection reasons
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> rejectedReasonIds() {
        return (JsonNullable<List<String>>) rejectedReasonIds;
    }

    /**
     * Provider's unique identifiers of the rejection reasons
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> remoteRejectedReasonIds() {
        return (JsonNullable<List<String>>) remoteRejectedReasonIds;
    }

    /**
     * Date of rejection
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> rejectedAt() {
        return rejectedAt;
    }

    /**
     * Unique identifier of the location
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> locationId() {
        return locationId;
    }

    /**
     * Provider's unique identifier of the location
     */
    @JsonIgnore
    public JsonNullable<String> remoteLocationId() {
        return remoteLocationId;
    }

    /**
     * Unique identifiers of the locations
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> locationIds() {
        return (JsonNullable<List<String>>) locationIds;
    }

    /**
     * Remote's unique identifiers of the locations
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> remoteLocationIds() {
        return (JsonNullable<List<String>>) remoteLocationIds;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ApplicationStatus> applicationStatus() {
        return (JsonNullable<ApplicationStatus>) applicationStatus;
    }

    /**
     * Questionnaires associated with the application
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<Questionnaire>> questionnaires() {
        return (JsonNullable<List<Questionnaire>>) questionnaires;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ApplicationCandidate> candidate() {
        return (JsonNullable<ApplicationCandidate>) candidate;
    }

    /**
     * Use `documents` expand instead
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<ApplicationAttachment>> attachments() {
        return (JsonNullable<List<ApplicationAttachment>>) attachments;
    }

    /**
     * The documents attached to this application (eg. resume, cover letter etc.)
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<AtsDocumentApiModel>> documents() {
        return (JsonNullable<List<AtsDocumentApiModel>>) documents;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<ResultLink>> resultLinks() {
        return (JsonNullable<List<ResultLink>>) resultLinks;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Source> source() {
        return (JsonNullable<Source>) source;
    }

    /**
     * Date of creation
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * Date of last update
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    /**
     * The application custom fields
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<CustomFields>> customFields() {
        return (JsonNullable<List<CustomFields>>) customFields;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Unique identifier
     */
    public Application withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Application withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Application withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Application withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Application withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Application withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * Unique identifier of the candidate
     */
    public Application withCandidateId(String candidateId) {
        Utils.checkNotNull(candidateId, "candidateId");
        this.candidateId = JsonNullable.of(candidateId);
        return this;
    }

    /**
     * Unique identifier of the candidate
     */
    public Application withCandidateId(JsonNullable<String> candidateId) {
        Utils.checkNotNull(candidateId, "candidateId");
        this.candidateId = candidateId;
        return this;
    }

    /**
     * Provider's unique identifier of the candidate
     */
    public Application withRemoteCandidateId(String remoteCandidateId) {
        Utils.checkNotNull(remoteCandidateId, "remoteCandidateId");
        this.remoteCandidateId = JsonNullable.of(remoteCandidateId);
        return this;
    }

    /**
     * Provider's unique identifier of the candidate
     */
    public Application withRemoteCandidateId(JsonNullable<String> remoteCandidateId) {
        Utils.checkNotNull(remoteCandidateId, "remoteCandidateId");
        this.remoteCandidateId = remoteCandidateId;
        return this;
    }

    /**
     * Unique identifier of the job
     */
    public Application withJobId(String jobId) {
        Utils.checkNotNull(jobId, "jobId");
        this.jobId = JsonNullable.of(jobId);
        return this;
    }

    /**
     * Unique identifier of the job
     */
    public Application withJobId(JsonNullable<String> jobId) {
        Utils.checkNotNull(jobId, "jobId");
        this.jobId = jobId;
        return this;
    }

    /**
     * Provider's unique identifier of the job
     */
    public Application withRemoteJobId(String remoteJobId) {
        Utils.checkNotNull(remoteJobId, "remoteJobId");
        this.remoteJobId = JsonNullable.of(remoteJobId);
        return this;
    }

    /**
     * Provider's unique identifier of the job
     */
    public Application withRemoteJobId(JsonNullable<String> remoteJobId) {
        Utils.checkNotNull(remoteJobId, "remoteJobId");
        this.remoteJobId = remoteJobId;
        return this;
    }

    public Application withInterviewStage(ApplicationInterviewStage interviewStage) {
        Utils.checkNotNull(interviewStage, "interviewStage");
        this.interviewStage = JsonNullable.of(interviewStage);
        return this;
    }

    public Application withInterviewStage(JsonNullable<? extends ApplicationInterviewStage> interviewStage) {
        Utils.checkNotNull(interviewStage, "interviewStage");
        this.interviewStage = interviewStage;
        return this;
    }

    /**
     * Unique identifier of the interview stage
     */
    public Application withInterviewStageId(String interviewStageId) {
        Utils.checkNotNull(interviewStageId, "interviewStageId");
        this.interviewStageId = JsonNullable.of(interviewStageId);
        return this;
    }

    /**
     * Unique identifier of the interview stage
     */
    public Application withInterviewStageId(JsonNullable<String> interviewStageId) {
        Utils.checkNotNull(interviewStageId, "interviewStageId");
        this.interviewStageId = interviewStageId;
        return this;
    }

    /**
     * Provider's unique identifier of the interview stage
     */
    public Application withRemoteInterviewStageId(String remoteInterviewStageId) {
        Utils.checkNotNull(remoteInterviewStageId, "remoteInterviewStageId");
        this.remoteInterviewStageId = JsonNullable.of(remoteInterviewStageId);
        return this;
    }

    /**
     * Provider's unique identifier of the interview stage
     */
    public Application withRemoteInterviewStageId(JsonNullable<String> remoteInterviewStageId) {
        Utils.checkNotNull(remoteInterviewStageId, "remoteInterviewStageId");
        this.remoteInterviewStageId = remoteInterviewStageId;
        return this;
    }

    public Application withRejectedReasons(List<RejectedReason> rejectedReasons) {
        Utils.checkNotNull(rejectedReasons, "rejectedReasons");
        this.rejectedReasons = JsonNullable.of(rejectedReasons);
        return this;
    }

    public Application withRejectedReasons(JsonNullable<? extends List<RejectedReason>> rejectedReasons) {
        Utils.checkNotNull(rejectedReasons, "rejectedReasons");
        this.rejectedReasons = rejectedReasons;
        return this;
    }

    /**
     * Unique identifiers of the rejection reasons
     */
    public Application withRejectedReasonIds(List<String> rejectedReasonIds) {
        Utils.checkNotNull(rejectedReasonIds, "rejectedReasonIds");
        this.rejectedReasonIds = JsonNullable.of(rejectedReasonIds);
        return this;
    }

    /**
     * Unique identifiers of the rejection reasons
     */
    public Application withRejectedReasonIds(JsonNullable<? extends List<String>> rejectedReasonIds) {
        Utils.checkNotNull(rejectedReasonIds, "rejectedReasonIds");
        this.rejectedReasonIds = rejectedReasonIds;
        return this;
    }

    /**
     * Provider's unique identifiers of the rejection reasons
     */
    public Application withRemoteRejectedReasonIds(List<String> remoteRejectedReasonIds) {
        Utils.checkNotNull(remoteRejectedReasonIds, "remoteRejectedReasonIds");
        this.remoteRejectedReasonIds = JsonNullable.of(remoteRejectedReasonIds);
        return this;
    }

    /**
     * Provider's unique identifiers of the rejection reasons
     */
    public Application withRemoteRejectedReasonIds(JsonNullable<? extends List<String>> remoteRejectedReasonIds) {
        Utils.checkNotNull(remoteRejectedReasonIds, "remoteRejectedReasonIds");
        this.remoteRejectedReasonIds = remoteRejectedReasonIds;
        return this;
    }

    /**
     * Date of rejection
     */
    public Application withRejectedAt(OffsetDateTime rejectedAt) {
        Utils.checkNotNull(rejectedAt, "rejectedAt");
        this.rejectedAt = JsonNullable.of(rejectedAt);
        return this;
    }

    /**
     * Date of rejection
     */
    public Application withRejectedAt(JsonNullable<OffsetDateTime> rejectedAt) {
        Utils.checkNotNull(rejectedAt, "rejectedAt");
        this.rejectedAt = rejectedAt;
        return this;
    }

    /**
     * Unique identifier of the location
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Application withLocationId(String locationId) {
        Utils.checkNotNull(locationId, "locationId");
        this.locationId = JsonNullable.of(locationId);
        return this;
    }

    /**
     * Unique identifier of the location
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Application withLocationId(JsonNullable<String> locationId) {
        Utils.checkNotNull(locationId, "locationId");
        this.locationId = locationId;
        return this;
    }

    /**
     * Provider's unique identifier of the location
     */
    public Application withRemoteLocationId(String remoteLocationId) {
        Utils.checkNotNull(remoteLocationId, "remoteLocationId");
        this.remoteLocationId = JsonNullable.of(remoteLocationId);
        return this;
    }

    /**
     * Provider's unique identifier of the location
     */
    public Application withRemoteLocationId(JsonNullable<String> remoteLocationId) {
        Utils.checkNotNull(remoteLocationId, "remoteLocationId");
        this.remoteLocationId = remoteLocationId;
        return this;
    }

    /**
     * Unique identifiers of the locations
     */
    public Application withLocationIds(List<String> locationIds) {
        Utils.checkNotNull(locationIds, "locationIds");
        this.locationIds = JsonNullable.of(locationIds);
        return this;
    }

    /**
     * Unique identifiers of the locations
     */
    public Application withLocationIds(JsonNullable<? extends List<String>> locationIds) {
        Utils.checkNotNull(locationIds, "locationIds");
        this.locationIds = locationIds;
        return this;
    }

    /**
     * Remote's unique identifiers of the locations
     */
    public Application withRemoteLocationIds(List<String> remoteLocationIds) {
        Utils.checkNotNull(remoteLocationIds, "remoteLocationIds");
        this.remoteLocationIds = JsonNullable.of(remoteLocationIds);
        return this;
    }

    /**
     * Remote's unique identifiers of the locations
     */
    public Application withRemoteLocationIds(JsonNullable<? extends List<String>> remoteLocationIds) {
        Utils.checkNotNull(remoteLocationIds, "remoteLocationIds");
        this.remoteLocationIds = remoteLocationIds;
        return this;
    }

    public Application withApplicationStatus(ApplicationStatus applicationStatus) {
        Utils.checkNotNull(applicationStatus, "applicationStatus");
        this.applicationStatus = JsonNullable.of(applicationStatus);
        return this;
    }

    public Application withApplicationStatus(JsonNullable<? extends ApplicationStatus> applicationStatus) {
        Utils.checkNotNull(applicationStatus, "applicationStatus");
        this.applicationStatus = applicationStatus;
        return this;
    }

    /**
     * Questionnaires associated with the application
     */
    public Application withQuestionnaires(List<Questionnaire> questionnaires) {
        Utils.checkNotNull(questionnaires, "questionnaires");
        this.questionnaires = JsonNullable.of(questionnaires);
        return this;
    }

    /**
     * Questionnaires associated with the application
     */
    public Application withQuestionnaires(JsonNullable<? extends List<Questionnaire>> questionnaires) {
        Utils.checkNotNull(questionnaires, "questionnaires");
        this.questionnaires = questionnaires;
        return this;
    }

    public Application withCandidate(ApplicationCandidate candidate) {
        Utils.checkNotNull(candidate, "candidate");
        this.candidate = JsonNullable.of(candidate);
        return this;
    }

    public Application withCandidate(JsonNullable<? extends ApplicationCandidate> candidate) {
        Utils.checkNotNull(candidate, "candidate");
        this.candidate = candidate;
        return this;
    }

    /**
     * Use `documents` expand instead
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Application withAttachments(List<ApplicationAttachment> attachments) {
        Utils.checkNotNull(attachments, "attachments");
        this.attachments = JsonNullable.of(attachments);
        return this;
    }

    /**
     * Use `documents` expand instead
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Application withAttachments(JsonNullable<? extends List<ApplicationAttachment>> attachments) {
        Utils.checkNotNull(attachments, "attachments");
        this.attachments = attachments;
        return this;
    }

    /**
     * The documents attached to this application (eg. resume, cover letter etc.)
     */
    public Application withDocuments(List<AtsDocumentApiModel> documents) {
        Utils.checkNotNull(documents, "documents");
        this.documents = JsonNullable.of(documents);
        return this;
    }

    /**
     * The documents attached to this application (eg. resume, cover letter etc.)
     */
    public Application withDocuments(JsonNullable<? extends List<AtsDocumentApiModel>> documents) {
        Utils.checkNotNull(documents, "documents");
        this.documents = documents;
        return this;
    }

    public Application withResultLinks(List<ResultLink> resultLinks) {
        Utils.checkNotNull(resultLinks, "resultLinks");
        this.resultLinks = JsonNullable.of(resultLinks);
        return this;
    }

    public Application withResultLinks(JsonNullable<? extends List<ResultLink>> resultLinks) {
        Utils.checkNotNull(resultLinks, "resultLinks");
        this.resultLinks = resultLinks;
        return this;
    }

    public Application withSource(Source source) {
        Utils.checkNotNull(source, "source");
        this.source = JsonNullable.of(source);
        return this;
    }

    public Application withSource(JsonNullable<? extends Source> source) {
        Utils.checkNotNull(source, "source");
        this.source = source;
        return this;
    }

    /**
     * Date of creation
     */
    public Application withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * Date of creation
     */
    public Application withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Date of last update
     */
    public Application withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * Date of last update
     */
    public Application withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    /**
     * The application custom fields
     */
    public Application withCustomFields(List<CustomFields> customFields) {
        Utils.checkNotNull(customFields, "customFields");
        this.customFields = JsonNullable.of(customFields);
        return this;
    }

    /**
     * The application custom fields
     */
    public Application withCustomFields(JsonNullable<? extends List<CustomFields>> customFields) {
        Utils.checkNotNull(customFields, "customFields");
        this.customFields = customFields;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Application other = (Application) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Objects.deepEquals(this.candidateId, other.candidateId) &&
            Objects.deepEquals(this.remoteCandidateId, other.remoteCandidateId) &&
            Objects.deepEquals(this.jobId, other.jobId) &&
            Objects.deepEquals(this.remoteJobId, other.remoteJobId) &&
            Objects.deepEquals(this.interviewStage, other.interviewStage) &&
            Objects.deepEquals(this.interviewStageId, other.interviewStageId) &&
            Objects.deepEquals(this.remoteInterviewStageId, other.remoteInterviewStageId) &&
            Objects.deepEquals(this.rejectedReasons, other.rejectedReasons) &&
            Objects.deepEquals(this.rejectedReasonIds, other.rejectedReasonIds) &&
            Objects.deepEquals(this.remoteRejectedReasonIds, other.remoteRejectedReasonIds) &&
            Objects.deepEquals(this.rejectedAt, other.rejectedAt) &&
            Objects.deepEquals(this.locationId, other.locationId) &&
            Objects.deepEquals(this.remoteLocationId, other.remoteLocationId) &&
            Objects.deepEquals(this.locationIds, other.locationIds) &&
            Objects.deepEquals(this.remoteLocationIds, other.remoteLocationIds) &&
            Objects.deepEquals(this.applicationStatus, other.applicationStatus) &&
            Objects.deepEquals(this.questionnaires, other.questionnaires) &&
            Objects.deepEquals(this.candidate, other.candidate) &&
            Objects.deepEquals(this.attachments, other.attachments) &&
            Objects.deepEquals(this.documents, other.documents) &&
            Objects.deepEquals(this.resultLinks, other.resultLinks) &&
            Objects.deepEquals(this.source, other.source) &&
            Objects.deepEquals(this.createdAt, other.createdAt) &&
            Objects.deepEquals(this.updatedAt, other.updatedAt) &&
            Objects.deepEquals(this.customFields, other.customFields);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            unifiedCustomFields,
            candidateId,
            remoteCandidateId,
            jobId,
            remoteJobId,
            interviewStage,
            interviewStageId,
            remoteInterviewStageId,
            rejectedReasons,
            rejectedReasonIds,
            remoteRejectedReasonIds,
            rejectedAt,
            locationId,
            remoteLocationId,
            locationIds,
            remoteLocationIds,
            applicationStatus,
            questionnaires,
            candidate,
            attachments,
            documents,
            resultLinks,
            source,
            createdAt,
            updatedAt,
            customFields);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Application.class,
                "id", id,
                "remoteId", remoteId,
                "unifiedCustomFields", unifiedCustomFields,
                "candidateId", candidateId,
                "remoteCandidateId", remoteCandidateId,
                "jobId", jobId,
                "remoteJobId", remoteJobId,
                "interviewStage", interviewStage,
                "interviewStageId", interviewStageId,
                "remoteInterviewStageId", remoteInterviewStageId,
                "rejectedReasons", rejectedReasons,
                "rejectedReasonIds", rejectedReasonIds,
                "remoteRejectedReasonIds", remoteRejectedReasonIds,
                "rejectedAt", rejectedAt,
                "locationId", locationId,
                "remoteLocationId", remoteLocationId,
                "locationIds", locationIds,
                "remoteLocationIds", remoteLocationIds,
                "applicationStatus", applicationStatus,
                "questionnaires", questionnaires,
                "candidate", candidate,
                "attachments", attachments,
                "documents", documents,
                "resultLinks", resultLinks,
                "source", source,
                "createdAt", createdAt,
                "updatedAt", updatedAt,
                "customFields", customFields);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();
 
        private JsonNullable<String> candidateId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteCandidateId = JsonNullable.undefined();
 
        private JsonNullable<String> jobId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteJobId = JsonNullable.undefined();
 
        private JsonNullable<? extends ApplicationInterviewStage> interviewStage = JsonNullable.undefined();
 
        private JsonNullable<String> interviewStageId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteInterviewStageId = JsonNullable.undefined();
 
        private JsonNullable<? extends List<RejectedReason>> rejectedReasons = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> rejectedReasonIds = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> remoteRejectedReasonIds = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> rejectedAt = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<String> locationId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteLocationId = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> locationIds = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> remoteLocationIds = JsonNullable.undefined();
 
        private JsonNullable<? extends ApplicationStatus> applicationStatus = JsonNullable.undefined();
 
        private JsonNullable<? extends List<Questionnaire>> questionnaires = JsonNullable.undefined();
 
        private JsonNullable<? extends ApplicationCandidate> candidate = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<? extends List<ApplicationAttachment>> attachments = JsonNullable.undefined();
 
        private JsonNullable<? extends List<AtsDocumentApiModel>> documents = JsonNullable.undefined();
 
        private JsonNullable<? extends List<ResultLink>> resultLinks = JsonNullable.undefined();
 
        private JsonNullable<? extends Source> source = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();
 
        private JsonNullable<? extends List<CustomFields>> customFields = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }

        /**
         * Unique identifier of the candidate
         */
        public Builder candidateId(String candidateId) {
            Utils.checkNotNull(candidateId, "candidateId");
            this.candidateId = JsonNullable.of(candidateId);
            return this;
        }

        /**
         * Unique identifier of the candidate
         */
        public Builder candidateId(JsonNullable<String> candidateId) {
            Utils.checkNotNull(candidateId, "candidateId");
            this.candidateId = candidateId;
            return this;
        }

        /**
         * Provider's unique identifier of the candidate
         */
        public Builder remoteCandidateId(String remoteCandidateId) {
            Utils.checkNotNull(remoteCandidateId, "remoteCandidateId");
            this.remoteCandidateId = JsonNullable.of(remoteCandidateId);
            return this;
        }

        /**
         * Provider's unique identifier of the candidate
         */
        public Builder remoteCandidateId(JsonNullable<String> remoteCandidateId) {
            Utils.checkNotNull(remoteCandidateId, "remoteCandidateId");
            this.remoteCandidateId = remoteCandidateId;
            return this;
        }

        /**
         * Unique identifier of the job
         */
        public Builder jobId(String jobId) {
            Utils.checkNotNull(jobId, "jobId");
            this.jobId = JsonNullable.of(jobId);
            return this;
        }

        /**
         * Unique identifier of the job
         */
        public Builder jobId(JsonNullable<String> jobId) {
            Utils.checkNotNull(jobId, "jobId");
            this.jobId = jobId;
            return this;
        }

        /**
         * Provider's unique identifier of the job
         */
        public Builder remoteJobId(String remoteJobId) {
            Utils.checkNotNull(remoteJobId, "remoteJobId");
            this.remoteJobId = JsonNullable.of(remoteJobId);
            return this;
        }

        /**
         * Provider's unique identifier of the job
         */
        public Builder remoteJobId(JsonNullable<String> remoteJobId) {
            Utils.checkNotNull(remoteJobId, "remoteJobId");
            this.remoteJobId = remoteJobId;
            return this;
        }

        public Builder interviewStage(ApplicationInterviewStage interviewStage) {
            Utils.checkNotNull(interviewStage, "interviewStage");
            this.interviewStage = JsonNullable.of(interviewStage);
            return this;
        }

        public Builder interviewStage(JsonNullable<? extends ApplicationInterviewStage> interviewStage) {
            Utils.checkNotNull(interviewStage, "interviewStage");
            this.interviewStage = interviewStage;
            return this;
        }

        /**
         * Unique identifier of the interview stage
         */
        public Builder interviewStageId(String interviewStageId) {
            Utils.checkNotNull(interviewStageId, "interviewStageId");
            this.interviewStageId = JsonNullable.of(interviewStageId);
            return this;
        }

        /**
         * Unique identifier of the interview stage
         */
        public Builder interviewStageId(JsonNullable<String> interviewStageId) {
            Utils.checkNotNull(interviewStageId, "interviewStageId");
            this.interviewStageId = interviewStageId;
            return this;
        }

        /**
         * Provider's unique identifier of the interview stage
         */
        public Builder remoteInterviewStageId(String remoteInterviewStageId) {
            Utils.checkNotNull(remoteInterviewStageId, "remoteInterviewStageId");
            this.remoteInterviewStageId = JsonNullable.of(remoteInterviewStageId);
            return this;
        }

        /**
         * Provider's unique identifier of the interview stage
         */
        public Builder remoteInterviewStageId(JsonNullable<String> remoteInterviewStageId) {
            Utils.checkNotNull(remoteInterviewStageId, "remoteInterviewStageId");
            this.remoteInterviewStageId = remoteInterviewStageId;
            return this;
        }

        public Builder rejectedReasons(List<RejectedReason> rejectedReasons) {
            Utils.checkNotNull(rejectedReasons, "rejectedReasons");
            this.rejectedReasons = JsonNullable.of(rejectedReasons);
            return this;
        }

        public Builder rejectedReasons(JsonNullable<? extends List<RejectedReason>> rejectedReasons) {
            Utils.checkNotNull(rejectedReasons, "rejectedReasons");
            this.rejectedReasons = rejectedReasons;
            return this;
        }

        /**
         * Unique identifiers of the rejection reasons
         */
        public Builder rejectedReasonIds(List<String> rejectedReasonIds) {
            Utils.checkNotNull(rejectedReasonIds, "rejectedReasonIds");
            this.rejectedReasonIds = JsonNullable.of(rejectedReasonIds);
            return this;
        }

        /**
         * Unique identifiers of the rejection reasons
         */
        public Builder rejectedReasonIds(JsonNullable<? extends List<String>> rejectedReasonIds) {
            Utils.checkNotNull(rejectedReasonIds, "rejectedReasonIds");
            this.rejectedReasonIds = rejectedReasonIds;
            return this;
        }

        /**
         * Provider's unique identifiers of the rejection reasons
         */
        public Builder remoteRejectedReasonIds(List<String> remoteRejectedReasonIds) {
            Utils.checkNotNull(remoteRejectedReasonIds, "remoteRejectedReasonIds");
            this.remoteRejectedReasonIds = JsonNullable.of(remoteRejectedReasonIds);
            return this;
        }

        /**
         * Provider's unique identifiers of the rejection reasons
         */
        public Builder remoteRejectedReasonIds(JsonNullable<? extends List<String>> remoteRejectedReasonIds) {
            Utils.checkNotNull(remoteRejectedReasonIds, "remoteRejectedReasonIds");
            this.remoteRejectedReasonIds = remoteRejectedReasonIds;
            return this;
        }

        /**
         * Date of rejection
         */
        public Builder rejectedAt(OffsetDateTime rejectedAt) {
            Utils.checkNotNull(rejectedAt, "rejectedAt");
            this.rejectedAt = JsonNullable.of(rejectedAt);
            return this;
        }

        /**
         * Date of rejection
         */
        public Builder rejectedAt(JsonNullable<OffsetDateTime> rejectedAt) {
            Utils.checkNotNull(rejectedAt, "rejectedAt");
            this.rejectedAt = rejectedAt;
            return this;
        }

        /**
         * Unique identifier of the location
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder locationId(String locationId) {
            Utils.checkNotNull(locationId, "locationId");
            this.locationId = JsonNullable.of(locationId);
            return this;
        }

        /**
         * Unique identifier of the location
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder locationId(JsonNullable<String> locationId) {
            Utils.checkNotNull(locationId, "locationId");
            this.locationId = locationId;
            return this;
        }

        /**
         * Provider's unique identifier of the location
         */
        public Builder remoteLocationId(String remoteLocationId) {
            Utils.checkNotNull(remoteLocationId, "remoteLocationId");
            this.remoteLocationId = JsonNullable.of(remoteLocationId);
            return this;
        }

        /**
         * Provider's unique identifier of the location
         */
        public Builder remoteLocationId(JsonNullable<String> remoteLocationId) {
            Utils.checkNotNull(remoteLocationId, "remoteLocationId");
            this.remoteLocationId = remoteLocationId;
            return this;
        }

        /**
         * Unique identifiers of the locations
         */
        public Builder locationIds(List<String> locationIds) {
            Utils.checkNotNull(locationIds, "locationIds");
            this.locationIds = JsonNullable.of(locationIds);
            return this;
        }

        /**
         * Unique identifiers of the locations
         */
        public Builder locationIds(JsonNullable<? extends List<String>> locationIds) {
            Utils.checkNotNull(locationIds, "locationIds");
            this.locationIds = locationIds;
            return this;
        }

        /**
         * Remote's unique identifiers of the locations
         */
        public Builder remoteLocationIds(List<String> remoteLocationIds) {
            Utils.checkNotNull(remoteLocationIds, "remoteLocationIds");
            this.remoteLocationIds = JsonNullable.of(remoteLocationIds);
            return this;
        }

        /**
         * Remote's unique identifiers of the locations
         */
        public Builder remoteLocationIds(JsonNullable<? extends List<String>> remoteLocationIds) {
            Utils.checkNotNull(remoteLocationIds, "remoteLocationIds");
            this.remoteLocationIds = remoteLocationIds;
            return this;
        }

        public Builder applicationStatus(ApplicationStatus applicationStatus) {
            Utils.checkNotNull(applicationStatus, "applicationStatus");
            this.applicationStatus = JsonNullable.of(applicationStatus);
            return this;
        }

        public Builder applicationStatus(JsonNullable<? extends ApplicationStatus> applicationStatus) {
            Utils.checkNotNull(applicationStatus, "applicationStatus");
            this.applicationStatus = applicationStatus;
            return this;
        }

        /**
         * Questionnaires associated with the application
         */
        public Builder questionnaires(List<Questionnaire> questionnaires) {
            Utils.checkNotNull(questionnaires, "questionnaires");
            this.questionnaires = JsonNullable.of(questionnaires);
            return this;
        }

        /**
         * Questionnaires associated with the application
         */
        public Builder questionnaires(JsonNullable<? extends List<Questionnaire>> questionnaires) {
            Utils.checkNotNull(questionnaires, "questionnaires");
            this.questionnaires = questionnaires;
            return this;
        }

        public Builder candidate(ApplicationCandidate candidate) {
            Utils.checkNotNull(candidate, "candidate");
            this.candidate = JsonNullable.of(candidate);
            return this;
        }

        public Builder candidate(JsonNullable<? extends ApplicationCandidate> candidate) {
            Utils.checkNotNull(candidate, "candidate");
            this.candidate = candidate;
            return this;
        }

        /**
         * Use `documents` expand instead
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder attachments(List<ApplicationAttachment> attachments) {
            Utils.checkNotNull(attachments, "attachments");
            this.attachments = JsonNullable.of(attachments);
            return this;
        }

        /**
         * Use `documents` expand instead
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder attachments(JsonNullable<? extends List<ApplicationAttachment>> attachments) {
            Utils.checkNotNull(attachments, "attachments");
            this.attachments = attachments;
            return this;
        }

        /**
         * The documents attached to this application (eg. resume, cover letter etc.)
         */
        public Builder documents(List<AtsDocumentApiModel> documents) {
            Utils.checkNotNull(documents, "documents");
            this.documents = JsonNullable.of(documents);
            return this;
        }

        /**
         * The documents attached to this application (eg. resume, cover letter etc.)
         */
        public Builder documents(JsonNullable<? extends List<AtsDocumentApiModel>> documents) {
            Utils.checkNotNull(documents, "documents");
            this.documents = documents;
            return this;
        }

        public Builder resultLinks(List<ResultLink> resultLinks) {
            Utils.checkNotNull(resultLinks, "resultLinks");
            this.resultLinks = JsonNullable.of(resultLinks);
            return this;
        }

        public Builder resultLinks(JsonNullable<? extends List<ResultLink>> resultLinks) {
            Utils.checkNotNull(resultLinks, "resultLinks");
            this.resultLinks = resultLinks;
            return this;
        }

        public Builder source(Source source) {
            Utils.checkNotNull(source, "source");
            this.source = JsonNullable.of(source);
            return this;
        }

        public Builder source(JsonNullable<? extends Source> source) {
            Utils.checkNotNull(source, "source");
            this.source = source;
            return this;
        }

        /**
         * Date of creation
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * Date of creation
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        /**
         * Date of last update
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * Date of last update
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * The application custom fields
         */
        public Builder customFields(List<CustomFields> customFields) {
            Utils.checkNotNull(customFields, "customFields");
            this.customFields = JsonNullable.of(customFields);
            return this;
        }

        /**
         * The application custom fields
         */
        public Builder customFields(JsonNullable<? extends List<CustomFields>> customFields) {
            Utils.checkNotNull(customFields, "customFields");
            this.customFields = customFields;
            return this;
        }
        
        public Application build() {
            return new Application(
                id,
                remoteId,
                unifiedCustomFields,
                candidateId,
                remoteCandidateId,
                jobId,
                remoteJobId,
                interviewStage,
                interviewStageId,
                remoteInterviewStageId,
                rejectedReasons,
                rejectedReasonIds,
                remoteRejectedReasonIds,
                rejectedAt,
                locationId,
                remoteLocationId,
                locationIds,
                remoteLocationIds,
                applicationStatus,
                questionnaires,
                candidate,
                attachments,
                documents,
                resultLinks,
                source,
                createdAt,
                updatedAt,
                customFields);
        }
    }
}
