/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Scorecard {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The sections in the scorecard
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("sections")
    private JsonNullable<? extends List<ScorecardSection>> sections;

    /**
     * The label of the scorecard
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("label")
    private JsonNullable<String> label;

    /**
     * The candidate ID associated with the scorecard
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("candidate_id")
    private JsonNullable<String> candidateId;

    /**
     * Provider's unique identifier of the candidate
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_candidate_id")
    private JsonNullable<String> remoteCandidateId;

    /**
     * The application ID associated with the scorecard
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("application_id")
    private JsonNullable<String> applicationId;

    /**
     * Provider's unique identifier of the application
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_application_id")
    private JsonNullable<String> remoteApplicationId;

    /**
     * The interview ID associated with the scorecard
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("interview_id")
    private JsonNullable<String> interviewId;

    /**
     * Provider's unique identifier of the interview
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_interview_id")
    private JsonNullable<String> remoteInterviewId;

    /**
     * The author ID of the scorecard
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("author_id")
    private JsonNullable<String> authorId;

    /**
     * Provider's unique identifier of the author
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_author_id")
    private JsonNullable<String> remoteAuthorId;

    /**
     * The overall recommendation
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("overall_recommendation")
    private JsonNullable<? extends OverallRecommendation> overallRecommendation;

    /**
     * The creation date of the scorecard
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The update date of the scorecard
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public Scorecard(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("sections") JsonNullable<? extends List<ScorecardSection>> sections,
            @JsonProperty("label") JsonNullable<String> label,
            @JsonProperty("candidate_id") JsonNullable<String> candidateId,
            @JsonProperty("remote_candidate_id") JsonNullable<String> remoteCandidateId,
            @JsonProperty("application_id") JsonNullable<String> applicationId,
            @JsonProperty("remote_application_id") JsonNullable<String> remoteApplicationId,
            @JsonProperty("interview_id") JsonNullable<String> interviewId,
            @JsonProperty("remote_interview_id") JsonNullable<String> remoteInterviewId,
            @JsonProperty("author_id") JsonNullable<String> authorId,
            @JsonProperty("remote_author_id") JsonNullable<String> remoteAuthorId,
            @JsonProperty("overall_recommendation") JsonNullable<? extends OverallRecommendation> overallRecommendation,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(sections, "sections");
        Utils.checkNotNull(label, "label");
        Utils.checkNotNull(candidateId, "candidateId");
        Utils.checkNotNull(remoteCandidateId, "remoteCandidateId");
        Utils.checkNotNull(applicationId, "applicationId");
        Utils.checkNotNull(remoteApplicationId, "remoteApplicationId");
        Utils.checkNotNull(interviewId, "interviewId");
        Utils.checkNotNull(remoteInterviewId, "remoteInterviewId");
        Utils.checkNotNull(authorId, "authorId");
        Utils.checkNotNull(remoteAuthorId, "remoteAuthorId");
        Utils.checkNotNull(overallRecommendation, "overallRecommendation");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.sections = sections;
        this.label = label;
        this.candidateId = candidateId;
        this.remoteCandidateId = remoteCandidateId;
        this.applicationId = applicationId;
        this.remoteApplicationId = remoteApplicationId;
        this.interviewId = interviewId;
        this.remoteInterviewId = remoteInterviewId;
        this.authorId = authorId;
        this.remoteAuthorId = remoteAuthorId;
        this.overallRecommendation = overallRecommendation;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public Scorecard() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The sections in the scorecard
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<ScorecardSection>> sections() {
        return (JsonNullable<List<ScorecardSection>>) sections;
    }

    /**
     * The label of the scorecard
     */
    @JsonIgnore
    public JsonNullable<String> label() {
        return label;
    }

    /**
     * The candidate ID associated with the scorecard
     */
    @JsonIgnore
    public JsonNullable<String> candidateId() {
        return candidateId;
    }

    /**
     * Provider's unique identifier of the candidate
     */
    @JsonIgnore
    public JsonNullable<String> remoteCandidateId() {
        return remoteCandidateId;
    }

    /**
     * The application ID associated with the scorecard
     */
    @JsonIgnore
    public JsonNullable<String> applicationId() {
        return applicationId;
    }

    /**
     * Provider's unique identifier of the application
     */
    @JsonIgnore
    public JsonNullable<String> remoteApplicationId() {
        return remoteApplicationId;
    }

    /**
     * The interview ID associated with the scorecard
     */
    @JsonIgnore
    public JsonNullable<String> interviewId() {
        return interviewId;
    }

    /**
     * Provider's unique identifier of the interview
     */
    @JsonIgnore
    public JsonNullable<String> remoteInterviewId() {
        return remoteInterviewId;
    }

    /**
     * The author ID of the scorecard
     */
    @JsonIgnore
    public JsonNullable<String> authorId() {
        return authorId;
    }

    /**
     * Provider's unique identifier of the author
     */
    @JsonIgnore
    public JsonNullable<String> remoteAuthorId() {
        return remoteAuthorId;
    }

    /**
     * The overall recommendation
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<OverallRecommendation> overallRecommendation() {
        return (JsonNullable<OverallRecommendation>) overallRecommendation;
    }

    /**
     * The creation date of the scorecard
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The update date of the scorecard
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Unique identifier
     */
    public Scorecard withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Scorecard withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Scorecard withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Scorecard withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The sections in the scorecard
     */
    public Scorecard withSections(List<ScorecardSection> sections) {
        Utils.checkNotNull(sections, "sections");
        this.sections = JsonNullable.of(sections);
        return this;
    }

    /**
     * The sections in the scorecard
     */
    public Scorecard withSections(JsonNullable<? extends List<ScorecardSection>> sections) {
        Utils.checkNotNull(sections, "sections");
        this.sections = sections;
        return this;
    }

    /**
     * The label of the scorecard
     */
    public Scorecard withLabel(String label) {
        Utils.checkNotNull(label, "label");
        this.label = JsonNullable.of(label);
        return this;
    }

    /**
     * The label of the scorecard
     */
    public Scorecard withLabel(JsonNullable<String> label) {
        Utils.checkNotNull(label, "label");
        this.label = label;
        return this;
    }

    /**
     * The candidate ID associated with the scorecard
     */
    public Scorecard withCandidateId(String candidateId) {
        Utils.checkNotNull(candidateId, "candidateId");
        this.candidateId = JsonNullable.of(candidateId);
        return this;
    }

    /**
     * The candidate ID associated with the scorecard
     */
    public Scorecard withCandidateId(JsonNullable<String> candidateId) {
        Utils.checkNotNull(candidateId, "candidateId");
        this.candidateId = candidateId;
        return this;
    }

    /**
     * Provider's unique identifier of the candidate
     */
    public Scorecard withRemoteCandidateId(String remoteCandidateId) {
        Utils.checkNotNull(remoteCandidateId, "remoteCandidateId");
        this.remoteCandidateId = JsonNullable.of(remoteCandidateId);
        return this;
    }

    /**
     * Provider's unique identifier of the candidate
     */
    public Scorecard withRemoteCandidateId(JsonNullable<String> remoteCandidateId) {
        Utils.checkNotNull(remoteCandidateId, "remoteCandidateId");
        this.remoteCandidateId = remoteCandidateId;
        return this;
    }

    /**
     * The application ID associated with the scorecard
     */
    public Scorecard withApplicationId(String applicationId) {
        Utils.checkNotNull(applicationId, "applicationId");
        this.applicationId = JsonNullable.of(applicationId);
        return this;
    }

    /**
     * The application ID associated with the scorecard
     */
    public Scorecard withApplicationId(JsonNullable<String> applicationId) {
        Utils.checkNotNull(applicationId, "applicationId");
        this.applicationId = applicationId;
        return this;
    }

    /**
     * Provider's unique identifier of the application
     */
    public Scorecard withRemoteApplicationId(String remoteApplicationId) {
        Utils.checkNotNull(remoteApplicationId, "remoteApplicationId");
        this.remoteApplicationId = JsonNullable.of(remoteApplicationId);
        return this;
    }

    /**
     * Provider's unique identifier of the application
     */
    public Scorecard withRemoteApplicationId(JsonNullable<String> remoteApplicationId) {
        Utils.checkNotNull(remoteApplicationId, "remoteApplicationId");
        this.remoteApplicationId = remoteApplicationId;
        return this;
    }

    /**
     * The interview ID associated with the scorecard
     */
    public Scorecard withInterviewId(String interviewId) {
        Utils.checkNotNull(interviewId, "interviewId");
        this.interviewId = JsonNullable.of(interviewId);
        return this;
    }

    /**
     * The interview ID associated with the scorecard
     */
    public Scorecard withInterviewId(JsonNullable<String> interviewId) {
        Utils.checkNotNull(interviewId, "interviewId");
        this.interviewId = interviewId;
        return this;
    }

    /**
     * Provider's unique identifier of the interview
     */
    public Scorecard withRemoteInterviewId(String remoteInterviewId) {
        Utils.checkNotNull(remoteInterviewId, "remoteInterviewId");
        this.remoteInterviewId = JsonNullable.of(remoteInterviewId);
        return this;
    }

    /**
     * Provider's unique identifier of the interview
     */
    public Scorecard withRemoteInterviewId(JsonNullable<String> remoteInterviewId) {
        Utils.checkNotNull(remoteInterviewId, "remoteInterviewId");
        this.remoteInterviewId = remoteInterviewId;
        return this;
    }

    /**
     * The author ID of the scorecard
     */
    public Scorecard withAuthorId(String authorId) {
        Utils.checkNotNull(authorId, "authorId");
        this.authorId = JsonNullable.of(authorId);
        return this;
    }

    /**
     * The author ID of the scorecard
     */
    public Scorecard withAuthorId(JsonNullable<String> authorId) {
        Utils.checkNotNull(authorId, "authorId");
        this.authorId = authorId;
        return this;
    }

    /**
     * Provider's unique identifier of the author
     */
    public Scorecard withRemoteAuthorId(String remoteAuthorId) {
        Utils.checkNotNull(remoteAuthorId, "remoteAuthorId");
        this.remoteAuthorId = JsonNullable.of(remoteAuthorId);
        return this;
    }

    /**
     * Provider's unique identifier of the author
     */
    public Scorecard withRemoteAuthorId(JsonNullable<String> remoteAuthorId) {
        Utils.checkNotNull(remoteAuthorId, "remoteAuthorId");
        this.remoteAuthorId = remoteAuthorId;
        return this;
    }

    /**
     * The overall recommendation
     */
    public Scorecard withOverallRecommendation(OverallRecommendation overallRecommendation) {
        Utils.checkNotNull(overallRecommendation, "overallRecommendation");
        this.overallRecommendation = JsonNullable.of(overallRecommendation);
        return this;
    }

    /**
     * The overall recommendation
     */
    public Scorecard withOverallRecommendation(JsonNullable<? extends OverallRecommendation> overallRecommendation) {
        Utils.checkNotNull(overallRecommendation, "overallRecommendation");
        this.overallRecommendation = overallRecommendation;
        return this;
    }

    /**
     * The creation date of the scorecard
     */
    public Scorecard withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The creation date of the scorecard
     */
    public Scorecard withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The update date of the scorecard
     */
    public Scorecard withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The update date of the scorecard
     */
    public Scorecard withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Scorecard other = (Scorecard) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.sections, other.sections) &&
            Objects.deepEquals(this.label, other.label) &&
            Objects.deepEquals(this.candidateId, other.candidateId) &&
            Objects.deepEquals(this.remoteCandidateId, other.remoteCandidateId) &&
            Objects.deepEquals(this.applicationId, other.applicationId) &&
            Objects.deepEquals(this.remoteApplicationId, other.remoteApplicationId) &&
            Objects.deepEquals(this.interviewId, other.interviewId) &&
            Objects.deepEquals(this.remoteInterviewId, other.remoteInterviewId) &&
            Objects.deepEquals(this.authorId, other.authorId) &&
            Objects.deepEquals(this.remoteAuthorId, other.remoteAuthorId) &&
            Objects.deepEquals(this.overallRecommendation, other.overallRecommendation) &&
            Objects.deepEquals(this.createdAt, other.createdAt) &&
            Objects.deepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            sections,
            label,
            candidateId,
            remoteCandidateId,
            applicationId,
            remoteApplicationId,
            interviewId,
            remoteInterviewId,
            authorId,
            remoteAuthorId,
            overallRecommendation,
            createdAt,
            updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Scorecard.class,
                "id", id,
                "remoteId", remoteId,
                "sections", sections,
                "label", label,
                "candidateId", candidateId,
                "remoteCandidateId", remoteCandidateId,
                "applicationId", applicationId,
                "remoteApplicationId", remoteApplicationId,
                "interviewId", interviewId,
                "remoteInterviewId", remoteInterviewId,
                "authorId", authorId,
                "remoteAuthorId", remoteAuthorId,
                "overallRecommendation", overallRecommendation,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<? extends List<ScorecardSection>> sections = JsonNullable.undefined();
 
        private JsonNullable<String> label = JsonNullable.undefined();
 
        private JsonNullable<String> candidateId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteCandidateId = JsonNullable.undefined();
 
        private JsonNullable<String> applicationId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteApplicationId = JsonNullable.undefined();
 
        private JsonNullable<String> interviewId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteInterviewId = JsonNullable.undefined();
 
        private JsonNullable<String> authorId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteAuthorId = JsonNullable.undefined();
 
        private JsonNullable<? extends OverallRecommendation> overallRecommendation = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * The sections in the scorecard
         */
        public Builder sections(List<ScorecardSection> sections) {
            Utils.checkNotNull(sections, "sections");
            this.sections = JsonNullable.of(sections);
            return this;
        }

        /**
         * The sections in the scorecard
         */
        public Builder sections(JsonNullable<? extends List<ScorecardSection>> sections) {
            Utils.checkNotNull(sections, "sections");
            this.sections = sections;
            return this;
        }

        /**
         * The label of the scorecard
         */
        public Builder label(String label) {
            Utils.checkNotNull(label, "label");
            this.label = JsonNullable.of(label);
            return this;
        }

        /**
         * The label of the scorecard
         */
        public Builder label(JsonNullable<String> label) {
            Utils.checkNotNull(label, "label");
            this.label = label;
            return this;
        }

        /**
         * The candidate ID associated with the scorecard
         */
        public Builder candidateId(String candidateId) {
            Utils.checkNotNull(candidateId, "candidateId");
            this.candidateId = JsonNullable.of(candidateId);
            return this;
        }

        /**
         * The candidate ID associated with the scorecard
         */
        public Builder candidateId(JsonNullable<String> candidateId) {
            Utils.checkNotNull(candidateId, "candidateId");
            this.candidateId = candidateId;
            return this;
        }

        /**
         * Provider's unique identifier of the candidate
         */
        public Builder remoteCandidateId(String remoteCandidateId) {
            Utils.checkNotNull(remoteCandidateId, "remoteCandidateId");
            this.remoteCandidateId = JsonNullable.of(remoteCandidateId);
            return this;
        }

        /**
         * Provider's unique identifier of the candidate
         */
        public Builder remoteCandidateId(JsonNullable<String> remoteCandidateId) {
            Utils.checkNotNull(remoteCandidateId, "remoteCandidateId");
            this.remoteCandidateId = remoteCandidateId;
            return this;
        }

        /**
         * The application ID associated with the scorecard
         */
        public Builder applicationId(String applicationId) {
            Utils.checkNotNull(applicationId, "applicationId");
            this.applicationId = JsonNullable.of(applicationId);
            return this;
        }

        /**
         * The application ID associated with the scorecard
         */
        public Builder applicationId(JsonNullable<String> applicationId) {
            Utils.checkNotNull(applicationId, "applicationId");
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Provider's unique identifier of the application
         */
        public Builder remoteApplicationId(String remoteApplicationId) {
            Utils.checkNotNull(remoteApplicationId, "remoteApplicationId");
            this.remoteApplicationId = JsonNullable.of(remoteApplicationId);
            return this;
        }

        /**
         * Provider's unique identifier of the application
         */
        public Builder remoteApplicationId(JsonNullable<String> remoteApplicationId) {
            Utils.checkNotNull(remoteApplicationId, "remoteApplicationId");
            this.remoteApplicationId = remoteApplicationId;
            return this;
        }

        /**
         * The interview ID associated with the scorecard
         */
        public Builder interviewId(String interviewId) {
            Utils.checkNotNull(interviewId, "interviewId");
            this.interviewId = JsonNullable.of(interviewId);
            return this;
        }

        /**
         * The interview ID associated with the scorecard
         */
        public Builder interviewId(JsonNullable<String> interviewId) {
            Utils.checkNotNull(interviewId, "interviewId");
            this.interviewId = interviewId;
            return this;
        }

        /**
         * Provider's unique identifier of the interview
         */
        public Builder remoteInterviewId(String remoteInterviewId) {
            Utils.checkNotNull(remoteInterviewId, "remoteInterviewId");
            this.remoteInterviewId = JsonNullable.of(remoteInterviewId);
            return this;
        }

        /**
         * Provider's unique identifier of the interview
         */
        public Builder remoteInterviewId(JsonNullable<String> remoteInterviewId) {
            Utils.checkNotNull(remoteInterviewId, "remoteInterviewId");
            this.remoteInterviewId = remoteInterviewId;
            return this;
        }

        /**
         * The author ID of the scorecard
         */
        public Builder authorId(String authorId) {
            Utils.checkNotNull(authorId, "authorId");
            this.authorId = JsonNullable.of(authorId);
            return this;
        }

        /**
         * The author ID of the scorecard
         */
        public Builder authorId(JsonNullable<String> authorId) {
            Utils.checkNotNull(authorId, "authorId");
            this.authorId = authorId;
            return this;
        }

        /**
         * Provider's unique identifier of the author
         */
        public Builder remoteAuthorId(String remoteAuthorId) {
            Utils.checkNotNull(remoteAuthorId, "remoteAuthorId");
            this.remoteAuthorId = JsonNullable.of(remoteAuthorId);
            return this;
        }

        /**
         * Provider's unique identifier of the author
         */
        public Builder remoteAuthorId(JsonNullable<String> remoteAuthorId) {
            Utils.checkNotNull(remoteAuthorId, "remoteAuthorId");
            this.remoteAuthorId = remoteAuthorId;
            return this;
        }

        /**
         * The overall recommendation
         */
        public Builder overallRecommendation(OverallRecommendation overallRecommendation) {
            Utils.checkNotNull(overallRecommendation, "overallRecommendation");
            this.overallRecommendation = JsonNullable.of(overallRecommendation);
            return this;
        }

        /**
         * The overall recommendation
         */
        public Builder overallRecommendation(JsonNullable<? extends OverallRecommendation> overallRecommendation) {
            Utils.checkNotNull(overallRecommendation, "overallRecommendation");
            this.overallRecommendation = overallRecommendation;
            return this;
        }

        /**
         * The creation date of the scorecard
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The creation date of the scorecard
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        /**
         * The update date of the scorecard
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The update date of the scorecard
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }
        
        public Scorecard build() {
            return new Scorecard(
                id,
                remoteId,
                sections,
                label,
                candidateId,
                remoteCandidateId,
                applicationId,
                remoteApplicationId,
                interviewId,
                remoteInterviewId,
                authorId,
                remoteAuthorId,
                overallRecommendation,
                createdAt,
                updatedAt);
        }
    }
}
