/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * TimeOffBalancesDurationUnit
 * 
 * <p>The duration unit of the current policy
 */
public class TimeOffBalancesDurationUnit {

    /**
     * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends TimeOffBalancesPolicyValue> value;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends TimeOffBalancesPolicySourceValue> sourceValue;

    @JsonCreator
    public TimeOffBalancesDurationUnit(
            @JsonProperty("value") JsonNullable<? extends TimeOffBalancesPolicyValue> value,
            @JsonProperty("source_value") JsonNullable<? extends TimeOffBalancesPolicySourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public TimeOffBalancesDurationUnit() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TimeOffBalancesPolicyValue> value() {
        return (JsonNullable<TimeOffBalancesPolicyValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TimeOffBalancesPolicySourceValue> sourceValue() {
        return (JsonNullable<TimeOffBalancesPolicySourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
     */
    public TimeOffBalancesDurationUnit withValue(TimeOffBalancesPolicyValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
     */
    public TimeOffBalancesDurationUnit withValue(JsonNullable<? extends TimeOffBalancesPolicyValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public TimeOffBalancesDurationUnit withSourceValue(TimeOffBalancesPolicySourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public TimeOffBalancesDurationUnit withSourceValue(JsonNullable<? extends TimeOffBalancesPolicySourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TimeOffBalancesDurationUnit other = (TimeOffBalancesDurationUnit) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TimeOffBalancesDurationUnit.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends TimeOffBalancesPolicyValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends TimeOffBalancesPolicySourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
         */
        public Builder value(TimeOffBalancesPolicyValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
         */
        public Builder value(JsonNullable<? extends TimeOffBalancesPolicyValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(TimeOffBalancesPolicySourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends TimeOffBalancesPolicySourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public TimeOffBalancesDurationUnit build() {
            return new TimeOffBalancesDurationUnit(
                value,
                sourceValue);
        }
    }
}
