/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TasksPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class HrisListEmployeeTasksResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends TasksPaginated> tasksPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<HrisListEmployeeTasksResponse>> next = () -> Optional.empty();

    @JsonCreator
    public HrisListEmployeeTasksResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends TasksPaginated> tasksPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(tasksPaginated, "tasksPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.tasksPaginated = tasksPaginated;
        this.headers = headers;
    }

    public HrisListEmployeeTasksResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TasksPaginated> tasksPaginated() {
        return this.tasksPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<HrisListEmployeeTasksResponse> next() throws Exception {
        return this.next.call();
    }

    private HrisListEmployeeTasksResponse withNext(Callable<Optional<HrisListEmployeeTasksResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public HrisListEmployeeTasksResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListEmployeeTasksResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListEmployeeTasksResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListEmployeeTasksResponse withTasksPaginated(TasksPaginated tasksPaginated) {
        Utils.checkNotNull(tasksPaginated, "tasksPaginated");
        this.tasksPaginated = Optional.ofNullable(tasksPaginated);
        return this;
    }

    public HrisListEmployeeTasksResponse withTasksPaginated(Optional<? extends TasksPaginated> tasksPaginated) {
        Utils.checkNotNull(tasksPaginated, "tasksPaginated");
        this.tasksPaginated = tasksPaginated;
        return this;
    }

    public HrisListEmployeeTasksResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeeTasksResponse other = (HrisListEmployeeTasksResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.tasksPaginated, other.tasksPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.tasksPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListEmployeeTasksResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "tasksPaginated", this.tasksPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<HrisListEmployeeTasksResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends TasksPaginated> tasksPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder tasksPaginated(TasksPaginated tasksPaginated) {
            Utils.checkNotNull(tasksPaginated, "tasksPaginated");
            this.tasksPaginated = Optional.ofNullable(tasksPaginated);
            return this;
        }

        public Builder tasksPaginated(Optional<? extends TasksPaginated> tasksPaginated) {
            Utils.checkNotNull(tasksPaginated, "tasksPaginated");
            this.tasksPaginated = tasksPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<HrisListEmployeeTasksResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public HrisListEmployeeTasksResponse build() {
            return new HrisListEmployeeTasksResponse(this.contentType, this.statusCode, this.rawResponse, this.tasksPaginated, this.headers).withNext(this.next);
        }
    }
}

