/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.models.components.ConnectSessionAuthenticate;
import com.stackone.stackone_client_java.models.components.ConnectSessionCreate;
import com.stackone.stackone_client_java.models.operations.StackoneAuthenticateConnectSessionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneAuthenticateConnectSessionResponse;
import com.stackone.stackone_client_java.models.operations.StackoneCreateConnectSessionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneCreateConnectSessionResponse;
import com.stackone.stackone_client_java.operations.StackoneAuthenticateConnectSessionOperation;
import com.stackone.stackone_client_java.operations.StackoneCreateConnectSessionOperation;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.Exception;
import java.util.List;
import java.util.Optional;

/**
 * Generate connection session tokens or auth URLs to allow your customers to connect their accounts.
 */
public class ConnectSessions {
    private final SDKConfiguration sdkConfiguration;

    ConnectSessions(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Create Connect Session
     * 
     * @return The call builder
     */
    public StackoneCreateConnectSessionRequestBuilder createConnectSession() {
        return new StackoneCreateConnectSessionRequestBuilder(sdkConfiguration);
    }

    /**
     * Create Connect Session
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneCreateConnectSessionResponse createConnectSession(ConnectSessionCreate request) throws Exception {
        return createConnectSession(request, Optional.empty());
    }

    /**
     * Create Connect Session
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneCreateConnectSessionResponse createConnectSession(
            ConnectSessionCreate request,
            Optional<Options> options) throws Exception {
        RequestOperation<ConnectSessionCreate, StackoneCreateConnectSessionResponse> operation
              = new StackoneCreateConnectSessionOperation(
                 sdkConfiguration,
                 options);
        return operation.handleResponse(operation.doRequest(request));
    }


    /**
     * Authenticate Connect Session
     * 
     * @return The call builder
     */
    public StackoneAuthenticateConnectSessionRequestBuilder authenticateConnectSession() {
        return new StackoneAuthenticateConnectSessionRequestBuilder(sdkConfiguration);
    }

    /**
     * Authenticate Connect Session
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneAuthenticateConnectSessionResponse authenticateConnectSession(ConnectSessionAuthenticate request) throws Exception {
        return authenticateConnectSession(request, Optional.empty());
    }

    /**
     * Authenticate Connect Session
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneAuthenticateConnectSessionResponse authenticateConnectSession(
            ConnectSessionAuthenticate request,
            Optional<Options> options) throws Exception {
        RequestOperation<ConnectSessionAuthenticate, StackoneAuthenticateConnectSessionResponse> operation
              = new StackoneAuthenticateConnectSessionOperation(
                 sdkConfiguration,
                 options);
        return operation.handleResponse(operation.doRequest(request));
    }

}
