/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * ChangeType
 * 
 * <p>The type of change that occurred to the application
 */
public class ChangeType {

    /**
     * The type of change that occurred to the application
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends ApplicationChangesValue> value;

    /**
     * The source value of the change type
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends ApplicationChangesSourceValue> sourceValue;

    @JsonCreator
    public ChangeType(
            @JsonProperty("value") JsonNullable<? extends ApplicationChangesValue> value,
            @JsonProperty("source_value") JsonNullable<? extends ApplicationChangesSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public ChangeType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The type of change that occurred to the application
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ApplicationChangesValue> value() {
        return (JsonNullable<ApplicationChangesValue>) value;
    }

    /**
     * The source value of the change type
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ApplicationChangesSourceValue> sourceValue() {
        return (JsonNullable<ApplicationChangesSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The type of change that occurred to the application
     */
    public ChangeType withValue(ApplicationChangesValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The type of change that occurred to the application
     */
    public ChangeType withValue(JsonNullable<? extends ApplicationChangesValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the change type
     */
    public ChangeType withSourceValue(ApplicationChangesSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the change type
     */
    public ChangeType withSourceValue(JsonNullable<? extends ApplicationChangesSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ChangeType other = (ChangeType) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ChangeType.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends ApplicationChangesValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends ApplicationChangesSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The type of change that occurred to the application
         */
        public Builder value(ApplicationChangesValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The type of change that occurred to the application
         */
        public Builder value(JsonNullable<? extends ApplicationChangesValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the change type
         */
        public Builder sourceValue(ApplicationChangesSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the change type
         */
        public Builder sourceValue(JsonNullable<? extends ApplicationChangesSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public ChangeType build() {
            return new ChangeType(
                value,
                sourceValue);
        }
    }
}
