/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * ContentBlockType
 * 
 * <p>Stackone enum identifying the type of content block.
 */
public class ContentBlockType {

    /**
     * The type of the content blocks.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends ContentBlockValue> value;

    /**
     * The source value of the type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends ContentBlockSourceValue> sourceValue;

    @JsonCreator
    public ContentBlockType(
            @JsonProperty("value") JsonNullable<? extends ContentBlockValue> value,
            @JsonProperty("source_value") JsonNullable<? extends ContentBlockSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public ContentBlockType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The type of the content blocks.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ContentBlockValue> value() {
        return (JsonNullable<ContentBlockValue>) value;
    }

    /**
     * The source value of the type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ContentBlockSourceValue> sourceValue() {
        return (JsonNullable<ContentBlockSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The type of the content blocks.
     */
    public ContentBlockType withValue(ContentBlockValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The type of the content blocks.
     */
    public ContentBlockType withValue(JsonNullable<? extends ContentBlockValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the type.
     */
    public ContentBlockType withSourceValue(ContentBlockSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the type.
     */
    public ContentBlockType withSourceValue(JsonNullable<? extends ContentBlockSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ContentBlockType other = (ContentBlockType) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ContentBlockType.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends ContentBlockValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends ContentBlockSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The type of the content blocks.
         */
        public Builder value(ContentBlockValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The type of the content blocks.
         */
        public Builder value(JsonNullable<? extends ContentBlockValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the type.
         */
        public Builder sourceValue(ContentBlockSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the type.
         */
        public Builder sourceValue(JsonNullable<? extends ContentBlockSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public ContentBlockType build() {
            return new ContentBlockType(
                value,
                sourceValue);
        }
    }
}
