/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * HRISBenefitValue
 * 
 * <p>The type of the benefit
 */
@JsonDeserialize(using = HRISBenefitValue._Deserializer.class)
@JsonSerialize(using = HRISBenefitValue._Serializer.class)
public class HRISBenefitValue {

    public static final HRISBenefitValue RETIREMENT_SAVINGS = new HRISBenefitValue("retirement_savings");
    public static final HRISBenefitValue HEALTH_SAVINGS = new HRISBenefitValue("health_savings");
    public static final HRISBenefitValue OTHER = new HRISBenefitValue("other");
    public static final HRISBenefitValue HEALTH_INSURANCE = new HRISBenefitValue("health_insurance");
    public static final HRISBenefitValue INSURANCE = new HRISBenefitValue("insurance");
    public static final HRISBenefitValue UNMAPPED_VALUE = new HRISBenefitValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, HRISBenefitValue> values = createValuesMap();
    private static final Map<String, HRISBenefitValueEnum> enums = createEnumsMap();

    private final String value;

    private HRISBenefitValue(String value) {
        this.value = value;
    }

    /**
     * Returns a HRISBenefitValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as HRISBenefitValue
     */ 
    public static HRISBenefitValue of(String value) {
        synchronized (HRISBenefitValue.class) {
            return values.computeIfAbsent(value, v -> new HRISBenefitValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<HRISBenefitValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        HRISBenefitValue other = (HRISBenefitValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "HRISBenefitValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static HRISBenefitValue[] values() {
        synchronized (HRISBenefitValue.class) {
            return values.values().toArray(new HRISBenefitValue[] {});
        }
    }

    private static final Map<String, HRISBenefitValue> createValuesMap() {
        Map<String, HRISBenefitValue> map = new LinkedHashMap<>();
        map.put("retirement_savings", RETIREMENT_SAVINGS);
        map.put("health_savings", HEALTH_SAVINGS);
        map.put("other", OTHER);
        map.put("health_insurance", HEALTH_INSURANCE);
        map.put("insurance", INSURANCE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HRISBenefitValueEnum> createEnumsMap() {
        Map<String, HRISBenefitValueEnum> map = new HashMap<>();
        map.put("retirement_savings", HRISBenefitValueEnum.RETIREMENT_SAVINGS);
        map.put("health_savings", HRISBenefitValueEnum.HEALTH_SAVINGS);
        map.put("other", HRISBenefitValueEnum.OTHER);
        map.put("health_insurance", HRISBenefitValueEnum.HEALTH_INSURANCE);
        map.put("insurance", HRISBenefitValueEnum.INSURANCE);
        map.put("unmapped_value", HRISBenefitValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<HRISBenefitValue> {

        protected _Serializer() {
            super(HRISBenefitValue.class);
        }

        @Override
        public void serialize(HRISBenefitValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<HRISBenefitValue> {

        protected _Deserializer() {
            super(HRISBenefitValue.class);
        }

        @Override
        public HRISBenefitValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return HRISBenefitValue.of(v);
        }
    }
    
    public enum HRISBenefitValueEnum {

        RETIREMENT_SAVINGS("retirement_savings"),
        HEALTH_SAVINGS("health_savings"),
        OTHER("other"),
        HEALTH_INSURANCE("health_insurance"),
        INSURANCE("insurance"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private HRISBenefitValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

