/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * StepLogResponse
 * 
 * <p>The advanced log response data
 */
public class StepLogResponse {

    /**
     * The response status code
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status_code")
    private JsonNullable<Double> statusCode;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("headers")
    private JsonNullable<? extends Map<String, Object>> headers;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("body")
    private JsonNullable<? extends Object> body;

    /**
     * The custom mapping errors
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("custom_mapping_errors")
    private JsonNullable<? extends List<CustomMappingError>> customMappingErrors;

    /**
     * The provider errors
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("provider_errors")
    private JsonNullable<? extends List<ProviderError>> providerErrors;

    @JsonCreator
    public StepLogResponse(
            @JsonProperty("status_code") JsonNullable<Double> statusCode,
            @JsonProperty("headers") JsonNullable<? extends Map<String, Object>> headers,
            @JsonProperty("body") JsonNullable<? extends Object> body,
            @JsonProperty("custom_mapping_errors") JsonNullable<? extends List<CustomMappingError>> customMappingErrors,
            @JsonProperty("provider_errors") JsonNullable<? extends List<ProviderError>> providerErrors) {
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(headers, "headers");
        Utils.checkNotNull(body, "body");
        Utils.checkNotNull(customMappingErrors, "customMappingErrors");
        Utils.checkNotNull(providerErrors, "providerErrors");
        this.statusCode = statusCode;
        this.headers = headers;
        this.body = body;
        this.customMappingErrors = customMappingErrors;
        this.providerErrors = providerErrors;
    }
    
    public StepLogResponse() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The response status code
     */
    @JsonIgnore
    public JsonNullable<Double> statusCode() {
        return statusCode;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> headers() {
        return (JsonNullable<Map<String, Object>>) headers;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Object> body() {
        return (JsonNullable<Object>) body;
    }

    /**
     * The custom mapping errors
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<CustomMappingError>> customMappingErrors() {
        return (JsonNullable<List<CustomMappingError>>) customMappingErrors;
    }

    /**
     * The provider errors
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<ProviderError>> providerErrors() {
        return (JsonNullable<List<ProviderError>>) providerErrors;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The response status code
     */
    public StepLogResponse withStatusCode(double statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = JsonNullable.of(statusCode);
        return this;
    }

    /**
     * The response status code
     */
    public StepLogResponse withStatusCode(JsonNullable<Double> statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public StepLogResponse withHeaders(Map<String, Object> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = JsonNullable.of(headers);
        return this;
    }

    public StepLogResponse withHeaders(JsonNullable<? extends Map<String, Object>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public StepLogResponse withBody(Object body) {
        Utils.checkNotNull(body, "body");
        this.body = JsonNullable.of(body);
        return this;
    }

    public StepLogResponse withBody(JsonNullable<? extends Object> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    /**
     * The custom mapping errors
     */
    public StepLogResponse withCustomMappingErrors(List<CustomMappingError> customMappingErrors) {
        Utils.checkNotNull(customMappingErrors, "customMappingErrors");
        this.customMappingErrors = JsonNullable.of(customMappingErrors);
        return this;
    }

    /**
     * The custom mapping errors
     */
    public StepLogResponse withCustomMappingErrors(JsonNullable<? extends List<CustomMappingError>> customMappingErrors) {
        Utils.checkNotNull(customMappingErrors, "customMappingErrors");
        this.customMappingErrors = customMappingErrors;
        return this;
    }

    /**
     * The provider errors
     */
    public StepLogResponse withProviderErrors(List<ProviderError> providerErrors) {
        Utils.checkNotNull(providerErrors, "providerErrors");
        this.providerErrors = JsonNullable.of(providerErrors);
        return this;
    }

    /**
     * The provider errors
     */
    public StepLogResponse withProviderErrors(JsonNullable<? extends List<ProviderError>> providerErrors) {
        Utils.checkNotNull(providerErrors, "providerErrors");
        this.providerErrors = providerErrors;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StepLogResponse other = (StepLogResponse) o;
        return 
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.headers, other.headers) &&
            Utils.enhancedDeepEquals(this.body, other.body) &&
            Utils.enhancedDeepEquals(this.customMappingErrors, other.customMappingErrors) &&
            Utils.enhancedDeepEquals(this.providerErrors, other.providerErrors);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            statusCode,
            headers,
            body,
            customMappingErrors,
            providerErrors);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StepLogResponse.class,
                "statusCode", statusCode,
                "headers", headers,
                "body", body,
                "customMappingErrors", customMappingErrors,
                "providerErrors", providerErrors);
    }
    
    public final static class Builder {
 
        private JsonNullable<Double> statusCode = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> headers = JsonNullable.undefined();
 
        private JsonNullable<? extends Object> body = JsonNullable.undefined();
 
        private JsonNullable<? extends List<CustomMappingError>> customMappingErrors = JsonNullable.undefined();
 
        private JsonNullable<? extends List<ProviderError>> providerErrors = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The response status code
         */
        public Builder statusCode(double statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = JsonNullable.of(statusCode);
            return this;
        }

        /**
         * The response status code
         */
        public Builder statusCode(JsonNullable<Double> statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder headers(Map<String, Object> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = JsonNullable.of(headers);
            return this;
        }

        public Builder headers(JsonNullable<? extends Map<String, Object>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public Builder body(Object body) {
            Utils.checkNotNull(body, "body");
            this.body = JsonNullable.of(body);
            return this;
        }

        public Builder body(JsonNullable<? extends Object> body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }

        /**
         * The custom mapping errors
         */
        public Builder customMappingErrors(List<CustomMappingError> customMappingErrors) {
            Utils.checkNotNull(customMappingErrors, "customMappingErrors");
            this.customMappingErrors = JsonNullable.of(customMappingErrors);
            return this;
        }

        /**
         * The custom mapping errors
         */
        public Builder customMappingErrors(JsonNullable<? extends List<CustomMappingError>> customMappingErrors) {
            Utils.checkNotNull(customMappingErrors, "customMappingErrors");
            this.customMappingErrors = customMappingErrors;
            return this;
        }

        /**
         * The provider errors
         */
        public Builder providerErrors(List<ProviderError> providerErrors) {
            Utils.checkNotNull(providerErrors, "providerErrors");
            this.providerErrors = JsonNullable.of(providerErrors);
            return this;
        }

        /**
         * The provider errors
         */
        public Builder providerErrors(JsonNullable<? extends List<ProviderError>> providerErrors) {
            Utils.checkNotNull(providerErrors, "providerErrors");
            this.providerErrors = providerErrors;
            return this;
        }
        
        public StepLogResponse build() {
            return new StepLogResponse(
                statusCode,
                headers,
                body,
                customMappingErrors,
                providerErrors);
        }
    }
}
